% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6-Repository.R
\name{Repository}
\alias{Repository}
\title{R6 Repository class.}
\description{
Class representing the Repository
}
\examples{
fetchedRepo <- tryCatch(
  {
    # Set dir to clone repository to.
    tempDir <- tempdir()
    pathToRepo <- file.path(tempDir, "glue")

    # Clone repo
    git2r::clone(
      url = "https://github.com/tidyverse/glue.git",
      local_path = pathToRepo
    )

    # Create instance of Repository object.
    repo <- PaRe::Repository$new(path = pathToRepo)

    # Set fetchedRepo to TRUE if all goes well.
    TRUE
  },
  error = function(e) {
    # Set fetchedRepo to FALSE if an error is encountered.
    FALSE
  },
  warning = function(w) {
    # Set fetchedRepo to FALSE if a warning is encountered.
    FALSE
  }
)

if (fetchedRepo) {
  repo
}
}
\seealso{
Other Representations: 
\code{\link{Code}},
\code{\link{File}},
\code{\link{Function}}
}
\concept{Representations}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Repository-new}{\code{Repository$new()}}
\item \href{#method-Repository-getName}{\code{Repository$getName()}}
\item \href{#method-Repository-getPath}{\code{Repository$getPath()}}
\item \href{#method-Repository-getFiles}{\code{Repository$getFiles()}}
\item \href{#method-Repository-getRFiles}{\code{Repository$getRFiles()}}
\item \href{#method-Repository-getDescription}{\code{Repository$getDescription()}}
\item \href{#method-Repository-getFunctionUse}{\code{Repository$getFunctionUse()}}
\item \href{#method-Repository-gitCheckout}{\code{Repository$gitCheckout()}}
\item \href{#method-Repository-gitPull}{\code{Repository$gitPull()}}
\item \href{#method-Repository-gitBlame}{\code{Repository$gitBlame()}}
\item \href{#method-Repository-clone}{\code{Repository$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Repository-new"></a>}}
\if{latex}{\out{\hypertarget{method-Repository-new}{}}}
\subsection{Method \code{new()}}{
Initializer for Repository class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Repository$new(path)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{path}}{(\link[base]{character})\cr
Path to R package project}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{invisible(self)}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Repository-getName"></a>}}
\if{latex}{\out{\hypertarget{method-Repository-getName}{}}}
\subsection{Method \code{getName()}}{
Get method for name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Repository$getName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[base]{character})\cr
Repository name
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Repository-getPath"></a>}}
\if{latex}{\out{\hypertarget{method-Repository-getPath}{}}}
\subsection{Method \code{getPath()}}{
Get method fro path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Repository$getPath()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[base]{character})\cr
Path to Repository folder
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Repository-getFiles"></a>}}
\if{latex}{\out{\hypertarget{method-Repository-getFiles}{}}}
\subsection{Method \code{getFiles()}}{
Get method to get a list of \link[PaRe]{File} objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Repository$getFiles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[base]{list})\cr
List of \link[PaRe]{File} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Repository-getRFiles"></a>}}
\if{latex}{\out{\hypertarget{method-Repository-getRFiles}{}}}
\subsection{Method \code{getRFiles()}}{
Get method to get only R-files.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Repository$getRFiles()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[base]{list})\cr
List of \link[PaRe]{File} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Repository-getDescription"></a>}}
\if{latex}{\out{\hypertarget{method-Repository-getDescription}{}}}
\subsection{Method \code{getDescription()}}{
Get method to get the description of the package. See: \link[desc]{description}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Repository$getDescription()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[desc]{description})\cr
Description object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Repository-getFunctionUse"></a>}}
\if{latex}{\out{\hypertarget{method-Repository-getFunctionUse}{}}}
\subsection{Method \code{getFunctionUse()}}{
Get method for functionUse, will check if functionUse has already been
fetched or not.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Repository$getFunctionUse()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[base]{data.frame})\cr
See \link[PaRe]{getFunctionUse}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Repository-gitCheckout"></a>}}
\if{latex}{\out{\hypertarget{method-Repository-gitCheckout}{}}}
\subsection{Method \code{gitCheckout()}}{
Method to run 'git checkout <branch/commit hash>'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Repository$gitCheckout(branch, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{branch}}{(\link[base]{character})\cr
Name of branch or a hash referencing a specific commit.}

\item{\code{...}}{Further parameters for \link[git2r]{checkout}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{invisible(self)}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Repository-gitPull"></a>}}
\if{latex}{\out{\hypertarget{method-Repository-gitPull}{}}}
\subsection{Method \code{gitPull()}}{
Method to run 'git pull'
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Repository$gitPull(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Further parameters for \link[git2r]{pull}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{invisible(self)}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Repository-gitBlame"></a>}}
\if{latex}{\out{\hypertarget{method-Repository-gitBlame}{}}}
\subsection{Method \code{gitBlame()}}{
Method to fetch data generated by 'git blame'.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Repository$gitBlame()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[dplyr]{tibble})\tabular{ll}{
   column \tab data type \cr
   repository \tab \link[base]{character} \cr
   author \tab \link[base]{character} \cr
   file \tab \link[base]{character} \cr
   date \tab \link[base]{character} \cr
   lines \tab \link[base]{integer} \cr
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Repository-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Repository-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Repository$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
