% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extensionScripts.R
\name{plotConditionalDensities}
\alias{plotConditionalDensities}
\title{Plot density of the target variable, conditional on the extension variable}
\usage{
plotConditionalDensities(
  y,
  fitX,
  yCP,
  xMed,
  medianY,
  link = "identity",
  dist = "best",
  N = 1e+05,
  xLimits = NULL,
  fs = 12
)
}
\arguments{
\item{y}{vector of values for the extension variable
at which to condition on.}

\item{fitX}{an object of class \code{elicitation} specifying the
c-distribution: the distribution of the target variable, conditional on the
extension variable taking its median value.}

\item{yCP}{vector of conditioning points for the extension variable.}

\item{xMed}{vector of medians of the target variable, corresponding to
each value of the extension variable in \code{yCP}.}

\item{medianY}{the median value of the extension variable.}

\item{link}{link in the median function. One of \code{"identity"},
\code{"log"} or \code{"logit"}}

\item{dist}{choice of parametric distribution for the c-distribution. Options are
\code{"normal"}, \code{"t"}, \code{"gamma"}, \code{"lognormal"},
\code{"logt"},\code{"beta"}, \code{"hist"} (for a histogram fit), and
\code{"best"} (for best fitting).}

\item{N}{sample size used in the kernel density estimate}

\item{xLimits}{x-axis limits}

\item{fs}{font size}
}
\description{
Plots kernel density estimates of the target variable, conditional on 
each of a set of specified values of the extension variable. The plot
makes use of the function \code{ggridges::geom_density_ridges()}, and so
uses kernel density estimates rather than the exact conditional density 
function.
}
\examples{
\dontrun{

myfitX <- fitdist(vals = c(5.5, 9, 14),
 probs = c(0.25, 0.5, 0.75),
 lower = 0)

plotConditionalDensities(y = c(2, 6, 10),
 fitX = myfitX,
 yCP = c(3, 5, 7, 9.5, 13.5),
 xMed = c(2, 6.5, 9, 13, 20),
 medianY = 7,
 link = "log",
 dist = "lognormal",
 xLimits = c(0, 60))

  
# Example with the logit link

myfitXlogit <- fitdist(vals = c(0.2, 0.25, 0.3),
 probs = c(0.25, 0.5, 0.75),
 lower = 0, 
 upper = 1)
 
 plotConditionalDensities(y = c(2, 6, 10),
  fitX = myfitXlogit, 
  yCP = c(2, 4, 6, 8, 10),
  xMed = c(0.1, 0.3, 0.5, 0.7, 0.9),
  medianY = 6,
  link = "logit",
  dist = "beta")
 
}

}
