% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.tsd_burden_levels}
\alias{summary.tsd_burden_levels}
\title{Summary method for \code{tsd_burden_levels} objects}
\usage{
\method{summary}{tsd_burden_levels}(object, ...)
}
\arguments{
\item{object}{An object of class 'tsd_burden_levels'
containing the results of a \code{seasonal_burden_levels} analysis.}

\item{...}{Additional arguments (not used).}
}
\value{
This function is used for its side effect, which is printing the burden levels.
}
\description{
Summarize key results from a seasonal burden levels analysis.
}
\examples{
# Create a `tsd` object
tsd_data <- generate_seasonal_data()

# Create a `tsd_burden_levels` object
tsd_burden_levels <- seasonal_burden_levels(
  tsd = tsd_data
)
# Print the summary
summary(tsd_burden_levels)
}
