% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2-actions.R
\name{ec2_modify_instance_metadata_options}
\alias{ec2_modify_instance_metadata_options}
\title{Modify Instance Metadata Options}
\usage{
ec2_modify_instance_metadata_options(
  InstanceId,
  HttpTokens = NULL,
  HttpPutResponseHopLimit = NULL,
  HttpEndpoint = NULL,
  DryRun = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{InstanceId}{Character. The ID of the instance.}

\item{HttpTokens}{Character.   The state of token usage for your instance metadata requests.[optional]}

\item{HttpPutResponseHopLimit}{Integer.   The desired HTTP PUT response hop limit for instance metadata requests.[optional]}

\item{HttpEndpoint}{Character.   This parameter enables or disables the HTTP metadata endpoint on your instances.[optional]}

\item{DryRun}{Logical. Checks whether you have the required permissions for the action, without actually making the request,...[optional]}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Modify the instance metadata
parameters on a running or stopped instance. When you modify the
parameters on a stopped instance, they are applied when the instance is
started. When you modify the parameters on a running instance, the API
responds with a state of \emph{pending}. After the parameter modifications
are successfully applied to the instance, the state of the modifications
changes from \emph{pending} to \emph{applied} in subsequent describe-instances
API calls. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html}{Instance metadata and user data}
in the \emph{Amazon EC2 User Guide}.
}
\section{InstanceId}{

The ID of the
instance.
}

\section{HttpTokens}{


The state of token usage for your instance metadata requests. If the
parameter is not specified in the request, the default state is
\code{optional}.

If the state is \code{optional}, you can choose to retrieve instance metadata
with or without a signed token header on your request. If you retrieve
the IAM role credentials without a token, the version 1.0 role
credentials are returned. If you retrieve the IAM role credentials using
a valid signed token, the version 2.0 role credentials are returned.

If the state is \code{required}, you must send a signed token header with any
instance metadata retrieval requests. In this state, retrieving the IAM
role credential always returns the version 2.0 credentials; the version
1.0 credentials are not available.
}

\section{HttpPutResponseHopLimit}{


The desired HTTP PUT response hop limit for instance metadata requests.
The larger the number, the further instance metadata requests can
travel. If no parameter is specified, the existing state is maintained.

Possible values: Integers from 1 to 64
}

\section{HttpEndpoint}{


This parameter enables or disables the HTTP metadata endpoint on your
instances. If the parameter is not specified, the existing state is
maintained.

If you specify a value of \code{disabled}, you will not be able to access
your instance metadata.
}

\section{DryRun}{

Checks whether you have the required permissions
for the action, without actually making the request, and provides an
error response. If you have the required permissions, the error response
is \code{DryRunOperation}. Otherwise, it is
\code{UnauthorizedOperation}.
}

