% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bart_package_inits.R
\name{get_var_counts_over_chain}
\alias{get_var_counts_over_chain}
\title{Get the Variable Inclusion Counts}
\usage{
get_var_counts_over_chain(bart_machine, type = "splits")
}
\arguments{
\item{bart_machine}{An object of class ``bartMachine''.}

\item{type}{If ``splits'', then the number of times each variable is chosen for a splitting rule is computed. If ``trees'', then the number of times each variable appears in a tree is computed.}
}
\value{
Returns a matrix of counts of each predictor across all trees by Gibbs sample. Thus, the dimension is \code{num_iterations_after_burn_in}
by \code{p} (where \code{p} is the number of predictors after dummifying factors and adding missingness dummies if specified by \code{use_missing_data_dummies_as_covars}).
}
\description{
Computes the variable inclusion counts for a BART model.
}
\examples{
\dontrun{

#generate Friedman data
set.seed(11)
n  = 200
p = 10
X = data.frame(matrix(runif(n * p), ncol = p))
y = 10 * sin(pi* X[ ,1] * X[,2]) +20 * (X[,3] -.5)^2 + 10 * X[ ,4] + 5 * X[,5] + rnorm(n)

##build BART regression model
bart_machine = bartMachine(X, y, num_trees = 20)

#get variable inclusion counts
var_counts = get_var_counts_over_chain(bart_machine)
print(var_counts)
}
}
\seealso{
\code{\link{get_var_props_over_chain}}
}
\author{
Adam Kapelner and Justin Bleich
}
