// Generated by rstantools.  Do not edit by hand.

/*
    bayeslist is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bayeslist is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bayeslist.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_model_misreport_doublelist_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'model_misreport_doublelist', line 42, column 1 to column 16)",
                                                      " (in 'model_misreport_doublelist', line 43, column 1 to column 17)",
                                                      " (in 'model_misreport_doublelist', line 44, column 1 to column 18)",
                                                      " (in 'model_misreport_doublelist', line 45, column 1 to column 14)",
                                                      " (in 'model_misreport_doublelist', line 46, column 1 to column 10)",
                                                      " (in 'model_misreport_doublelist', line 47, column 1 to column 10)",
                                                      " (in 'model_misreport_doublelist', line 48, column 1 to column 33)",
                                                      " (in 'model_misreport_doublelist', line 53, column 2 to column 46)",
                                                      " (in 'model_misreport_doublelist', line 54, column 2 to column 51)",
                                                      " (in 'model_misreport_doublelist', line 55, column 2 to column 48)",
                                                      " (in 'model_misreport_doublelist', line 52, column 15 to line 56, column 2)",
                                                      " (in 'model_misreport_doublelist', line 52, column 1 to line 56, column 2)",
                                                      " (in 'model_misreport_doublelist', line 57, column 1 to column 36)",
                                                      " (in 'model_misreport_doublelist', line 58, column 1 to column 43)",
                                                      " (in 'model_misreport_doublelist', line 59, column 1 to column 31)",
                                                      " (in 'model_misreport_doublelist', line 60, column 1 to column 31)",
                                                      " (in 'model_misreport_doublelist', line 75, column 3 to column 15)",
                                                      " (in 'model_misreport_doublelist', line 74, column 9 to line 76, column 3)",
                                                      " (in 'model_misreport_doublelist', line 73, column 3 to column 211)",
                                                      " (in 'model_misreport_doublelist', line 72, column 57 to line 74, column 3)",
                                                      " (in 'model_misreport_doublelist', line 72, column 9 to line 76, column 3)",
                                                      " (in 'model_misreport_doublelist', line 71, column 3 to column 374)",
                                                      " (in 'model_misreport_doublelist', line 70, column 46 to line 72, column 3)",
                                                      " (in 'model_misreport_doublelist', line 70, column 9 to line 76, column 3)",
                                                      " (in 'model_misreport_doublelist', line 69, column 3 to column 202)",
                                                      " (in 'model_misreport_doublelist', line 68, column 63 to line 70, column 3)",
                                                      " (in 'model_misreport_doublelist', line 68, column 9 to line 76, column 3)",
                                                      " (in 'model_misreport_doublelist', line 67, column 3 to column 150)",
                                                      " (in 'model_misreport_doublelist', line 66, column 59 to line 68, column 3)",
                                                      " (in 'model_misreport_doublelist', line 66, column 9 to line 76, column 3)",
                                                      " (in 'model_misreport_doublelist', line 65, column 3 to column 197)",
                                                      " (in 'model_misreport_doublelist', line 64, column 46 to line 66, column 3)",
                                                      " (in 'model_misreport_doublelist', line 64, column 9 to line 76, column 3)",
                                                      " (in 'model_misreport_doublelist', line 63, column 3 to column 359)",
                                                      " (in 'model_misreport_doublelist', line 62, column 38 to line 64, column 3)",
                                                      " (in 'model_misreport_doublelist', line 62, column 2 to line 76, column 3)",
                                                      " (in 'model_misreport_doublelist', line 61, column 15 to line 79, column 2)",
                                                      " (in 'model_misreport_doublelist', line 61, column 1 to line 79, column 2)",
                                                      " (in 'model_misreport_doublelist', line 17, column 1 to column 7)",
                                                      " (in 'model_misreport_doublelist', line 18, column 1 to column 7)",
                                                      " (in 'model_misreport_doublelist', line 19, column 18 to column 19)",
                                                      " (in 'model_misreport_doublelist', line 19, column 1 to column 21)",
                                                      " (in 'model_misreport_doublelist', line 20, column 1 to column 7)",
                                                      " (in 'model_misreport_doublelist', line 21, column 8 to column 9)",
                                                      " (in 'model_misreport_doublelist', line 21, column 10 to column 11)",
                                                      " (in 'model_misreport_doublelist', line 21, column 1 to column 15)",
                                                      " (in 'model_misreport_doublelist', line 22, column 11 to column 12)",
                                                      " (in 'model_misreport_doublelist', line 22, column 1 to column 14)",
                                                      " (in 'model_misreport_doublelist', line 23, column 12 to column 13)",
                                                      " (in 'model_misreport_doublelist', line 23, column 1 to column 15)",
                                                      " (in 'model_misreport_doublelist', line 24, column 14 to column 15)",
                                                      " (in 'model_misreport_doublelist', line 24, column 1 to column 17)",
                                                      " (in 'model_misreport_doublelist', line 25, column 28 to column 29)",
                                                      " (in 'model_misreport_doublelist', line 25, column 1 to column 31)",
                                                      " (in 'model_misreport_doublelist', line 26, column 15 to column 16)",
                                                      " (in 'model_misreport_doublelist', line 26, column 1 to column 18)",
                                                      " (in 'model_misreport_doublelist', line 27, column 29 to column 30)",
                                                      " (in 'model_misreport_doublelist', line 27, column 1 to column 32)",
                                                      " (in 'model_misreport_doublelist', line 28, column 16 to column 17)",
                                                      " (in 'model_misreport_doublelist', line 28, column 1 to column 19)",
                                                      " (in 'model_misreport_doublelist', line 29, column 30 to column 31)",
                                                      " (in 'model_misreport_doublelist', line 29, column 1 to column 33)",
                                                      " (in 'model_misreport_doublelist', line 30, column 1 to column 16)",
                                                      " (in 'model_misreport_doublelist', line 31, column 1 to column 30)",
                                                      " (in 'model_misreport_doublelist', line 32, column 1 to column 12)",
                                                      " (in 'model_misreport_doublelist', line 33, column 1 to column 26)",
                                                      " (in 'model_misreport_doublelist', line 34, column 1 to column 12)",
                                                      " (in 'model_misreport_doublelist', line 35, column 1 to column 26)",
                                                      " (in 'model_misreport_doublelist', line 36, column 1 to column 14)",
                                                      " (in 'model_misreport_doublelist', line 37, column 1 to column 28)",
                                                      " (in 'model_misreport_doublelist', line 42, column 8 to column 9)",
                                                      " (in 'model_misreport_doublelist', line 43, column 8 to column 9)",
                                                      " (in 'model_misreport_doublelist', line 44, column 8 to column 9)",
                                                      " (in 'model_misreport_doublelist', line 4, column 2 to column 31)",
                                                      " (in 'model_misreport_doublelist', line 3, column 16 to line 5, column 2)",
                                                      " (in 'model_misreport_doublelist', line 7, column 2 to column 31)",
                                                      " (in 'model_misreport_doublelist', line 6, column 16 to line 8, column 2)",
                                                      " (in 'model_misreport_doublelist', line 10, column 2 to column 45)",
                                                      " (in 'model_misreport_doublelist', line 9, column 46 to line 11, column 2)",
                                                      " (in 'model_misreport_doublelist', line 13, column 2 to column 45)",
                                                      " (in 'model_misreport_doublelist', line 12, column 46 to line 14, column 2)"};
template <typename T0__>
stan::promote_args_t<T0__>
gd(const T0__& p, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 74;
    return binomial_lpmf<false>(1, 1, p);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct gd_functor__ {
template <typename T0__>
stan::promote_args_t<T0__>
operator()(const T0__& p, std::ostream* pstream__)  const 
{
return gd(p, pstream__);
}
};
template <typename T0__>
stan::promote_args_t<T0__>
jd(const T0__& p, std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 76;
    return binomial_lpmf<false>(1, 1, p);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct jd_functor__ {
template <typename T0__>
stan::promote_args_t<T0__>
operator()(const T0__& p, std::ostream* pstream__)  const 
{
return jd(p, pstream__);
}
};
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
h0d(const int& y, const int& J, const T2__& alpha, const T3__& beta,
    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T2__, T3__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 78;
    return beta_binomial_lpmf<false>(y, J, alpha, beta);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct h0d_functor__ {
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
operator()(const int& y, const int& J, const T2__& alpha, const T3__& beta,
           std::ostream* pstream__)  const 
{
return h0d(y, J, alpha, beta, pstream__);
}
};
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
h1d(const int& y, const int& J, const T2__& alpha, const T3__& beta,
    std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T2__, T3__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    current_statement__ = 80;
    return beta_binomial_lpmf<false>(y, J, alpha, beta);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct h1d_functor__ {
template <typename T2__, typename T3__>
stan::promote_args_t<T2__,
T3__>
operator()(const int& y, const int& J, const T2__& alpha, const T3__& beta,
           std::ostream* pstream__)  const 
{
return h1d(y, J, alpha, beta, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_model_misreport_doublelist final : public model_base_crtp<model_model_misreport_doublelist> {
private:
  int N;
  int J;
  std::vector<int> Y;
  int K;
  Eigen::Matrix<double, -1, -1> X;
  std::vector<int> treat;
  std::vector<int> direct;
  std::vector<double> mu_psi0;
  std::vector<double> sigma_psi0;
  std::vector<double> mu_delta;
  std::vector<double> sigma_delta;
  std::vector<double> mu_gamma0;
  std::vector<double> sigma_gamma0;
  double mu_treate;
  double sigma_treate;
  double mu_ue;
  double sigma_ue;
  double mu_ze;
  double sigma_ze;
  double mu_rho0;
  double sigma_rho0;
 
public:
  ~model_model_misreport_doublelist() { }
  
  inline std::string model_name() const final { return "model_model_misreport_doublelist"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_model_misreport_doublelist(stan::io::var_context& context__,
                                   unsigned int random_seed__ = 0,
                                   std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_model_misreport_doublelist_namespace::model_model_misreport_doublelist";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 39;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 39;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 40;
      context__.validate_dims("data initialization","J","int",
          context__.to_vec());
      J = std::numeric_limits<int>::min();
      
      current_statement__ = 40;
      J = context__.vals_i("J")[(1 - 1)];
      current_statement__ = 41;
      validate_non_negative_index("Y", "N", N);
      current_statement__ = 42;
      context__.validate_dims("data initialization","Y","int",
          context__.to_vec(N));
      Y = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 42;
      assign(Y, nil_index_list(), context__.vals_i("Y"),
        "assigning variable Y");
      current_statement__ = 42;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 42;
        current_statement__ = 42;
        check_greater_or_equal(function__, "Y[sym1__]", Y[(sym1__ - 1)], 0);}
      current_statement__ = 43;
      context__.validate_dims("data initialization","K","int",
          context__.to_vec());
      K = std::numeric_limits<int>::min();
      
      current_statement__ = 43;
      K = context__.vals_i("K")[(1 - 1)];
      current_statement__ = 44;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 45;
      validate_non_negative_index("X", "K", K);
      current_statement__ = 46;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N, K));
      X = Eigen::Matrix<double, -1, -1>(N, K);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 46;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 46;
        pos__ = 1;
        current_statement__ = 46;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 46;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 46;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 46;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 47;
      validate_non_negative_index("treat", "N", N);
      current_statement__ = 48;
      context__.validate_dims("data initialization","treat","int",
          context__.to_vec(N));
      treat = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 48;
      assign(treat, nil_index_list(), context__.vals_i("treat"),
        "assigning variable treat");
      current_statement__ = 49;
      validate_non_negative_index("direct", "N", N);
      current_statement__ = 50;
      context__.validate_dims("data initialization","direct","int",
          context__.to_vec(N));
      direct = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 50;
      assign(direct, nil_index_list(), context__.vals_i("direct"),
        "assigning variable direct");
      current_statement__ = 51;
      validate_non_negative_index("mu_psi0", "K", K);
      current_statement__ = 52;
      context__.validate_dims("data initialization","mu_psi0","double",
          context__.to_vec(K));
      mu_psi0 = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 52;
      assign(mu_psi0, nil_index_list(), context__.vals_r("mu_psi0"),
        "assigning variable mu_psi0");
      current_statement__ = 53;
      validate_non_negative_index("sigma_psi0", "K", K);
      current_statement__ = 54;
      context__.validate_dims("data initialization","sigma_psi0","double",
          context__.to_vec(K));
      sigma_psi0 = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 54;
      assign(sigma_psi0, nil_index_list(), context__.vals_r("sigma_psi0"),
        "assigning variable sigma_psi0");
      current_statement__ = 54;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 54;
        current_statement__ = 54;
        check_greater_or_equal(function__, "sigma_psi0[sym1__]",
                               sigma_psi0[(sym1__ - 1)], 0);}
      current_statement__ = 55;
      validate_non_negative_index("mu_delta", "K", K);
      current_statement__ = 56;
      context__.validate_dims("data initialization","mu_delta","double",
          context__.to_vec(K));
      mu_delta = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 56;
      assign(mu_delta, nil_index_list(), context__.vals_r("mu_delta"),
        "assigning variable mu_delta");
      current_statement__ = 57;
      validate_non_negative_index("sigma_delta", "K", K);
      current_statement__ = 58;
      context__.validate_dims("data initialization","sigma_delta","double",
          context__.to_vec(K));
      sigma_delta = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 58;
      assign(sigma_delta, nil_index_list(), context__.vals_r("sigma_delta"),
        "assigning variable sigma_delta");
      current_statement__ = 58;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 58;
        current_statement__ = 58;
        check_greater_or_equal(function__, "sigma_delta[sym1__]",
                               sigma_delta[(sym1__ - 1)], 0);}
      current_statement__ = 59;
      validate_non_negative_index("mu_gamma0", "K", K);
      current_statement__ = 60;
      context__.validate_dims("data initialization","mu_gamma0","double",
          context__.to_vec(K));
      mu_gamma0 = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 60;
      assign(mu_gamma0, nil_index_list(), context__.vals_r("mu_gamma0"),
        "assigning variable mu_gamma0");
      current_statement__ = 61;
      validate_non_negative_index("sigma_gamma0", "K", K);
      current_statement__ = 62;
      context__.validate_dims("data initialization","sigma_gamma0","double",
          context__.to_vec(K));
      sigma_gamma0 = std::vector<double>(K, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 62;
      assign(sigma_gamma0, nil_index_list(),
        context__.vals_r("sigma_gamma0"), "assigning variable sigma_gamma0");
      current_statement__ = 62;
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        current_statement__ = 62;
        current_statement__ = 62;
        check_greater_or_equal(function__, "sigma_gamma0[sym1__]",
                               sigma_gamma0[(sym1__ - 1)], 0);}
      current_statement__ = 63;
      context__.validate_dims("data initialization","mu_treate","double",
          context__.to_vec());
      mu_treate = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 63;
      mu_treate = context__.vals_r("mu_treate")[(1 - 1)];
      current_statement__ = 64;
      context__.validate_dims("data initialization","sigma_treate","double",
          context__.to_vec());
      sigma_treate = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 64;
      sigma_treate = context__.vals_r("sigma_treate")[(1 - 1)];
      current_statement__ = 64;
      current_statement__ = 64;
      check_greater_or_equal(function__, "sigma_treate", sigma_treate, 0);
      current_statement__ = 65;
      context__.validate_dims("data initialization","mu_ue","double",
          context__.to_vec());
      mu_ue = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 65;
      mu_ue = context__.vals_r("mu_ue")[(1 - 1)];
      current_statement__ = 66;
      context__.validate_dims("data initialization","sigma_ue","double",
          context__.to_vec());
      sigma_ue = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 66;
      sigma_ue = context__.vals_r("sigma_ue")[(1 - 1)];
      current_statement__ = 66;
      current_statement__ = 66;
      check_greater_or_equal(function__, "sigma_ue", sigma_ue, 0);
      current_statement__ = 67;
      context__.validate_dims("data initialization","mu_ze","double",
          context__.to_vec());
      mu_ze = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 67;
      mu_ze = context__.vals_r("mu_ze")[(1 - 1)];
      current_statement__ = 68;
      context__.validate_dims("data initialization","sigma_ze","double",
          context__.to_vec());
      sigma_ze = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 68;
      sigma_ze = context__.vals_r("sigma_ze")[(1 - 1)];
      current_statement__ = 68;
      current_statement__ = 68;
      check_greater_or_equal(function__, "sigma_ze", sigma_ze, 0);
      current_statement__ = 69;
      context__.validate_dims("data initialization","mu_rho0","double",
          context__.to_vec());
      mu_rho0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 69;
      mu_rho0 = context__.vals_r("mu_rho0")[(1 - 1)];
      current_statement__ = 70;
      context__.validate_dims("data initialization","sigma_rho0","double",
          context__.to_vec());
      sigma_rho0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 70;
      sigma_rho0 = context__.vals_r("sigma_rho0")[(1 - 1)];
      current_statement__ = 70;
      current_statement__ = 70;
      check_greater_or_equal(function__, "sigma_rho0", sigma_rho0, 0);
      current_statement__ = 71;
      validate_non_negative_index("psi0", "K", K);
      current_statement__ = 72;
      validate_non_negative_index("delta", "K", K);
      current_statement__ = 73;
      validate_non_negative_index("gamma0", "K", K);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += K;
      num_params_r__ += K;
      num_params_r__ += K;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_model_misreport_doublelist_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<local_scalar_t__, -1, 1> psi0;
      psi0 = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(psi0, DUMMY_VAR__);
      
      current_statement__ = 1;
      psi0 = in__.vector(K);
      Eigen::Matrix<local_scalar_t__, -1, 1> delta;
      delta = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(delta, DUMMY_VAR__);
      
      current_statement__ = 2;
      delta = in__.vector(K);
      Eigen::Matrix<local_scalar_t__, -1, 1> gamma0;
      gamma0 = Eigen::Matrix<local_scalar_t__, -1, 1>(K);
      stan::math::fill(gamma0, DUMMY_VAR__);
      
      current_statement__ = 3;
      gamma0 = in__.vector(K);
      local_scalar_t__ treat_e;
      treat_e = DUMMY_VAR__;
      
      current_statement__ = 4;
      treat_e = in__.scalar();
      local_scalar_t__ U_e;
      U_e = DUMMY_VAR__;
      
      current_statement__ = 5;
      U_e = in__.scalar();
      local_scalar_t__ Z_e;
      Z_e = DUMMY_VAR__;
      
      current_statement__ = 6;
      Z_e = in__.scalar();
      local_scalar_t__ rho0;
      rho0 = DUMMY_VAR__;
      
      current_statement__ = 7;
      rho0 = in__.scalar();
      current_statement__ = 7;
      if (jacobian__) {
        current_statement__ = 7;
        rho0 = stan::math::lub_constrain(rho0, 0, 1, lp__);
      } else {
        current_statement__ = 7;
        rho0 = stan::math::lub_constrain(rho0, 0, 1);
      }
      {
        current_statement__ = 12;
        for (int i = 1; i <= K; ++i) {
          current_statement__ = 8;
          lp_accum__.add(
            normal_lpdf<propto__>(psi0[(i - 1)], mu_psi0[(i - 1)],
              sigma_psi0[(i - 1)]));
          current_statement__ = 9;
          lp_accum__.add(
            normal_lpdf<propto__>(gamma0[(i - 1)], mu_gamma0[(i - 1)],
              sigma_gamma0[(i - 1)]));
          current_statement__ = 10;
          lp_accum__.add(
            normal_lpdf<propto__>(delta[(i - 1)], mu_delta[(i - 1)],
              sigma_delta[(i - 1)]));}
        current_statement__ = 13;
        lp_accum__.add(normal_lpdf<propto__>(rho0, mu_rho0, sigma_rho0));
        current_statement__ = 14;
        lp_accum__.add(
          normal_lpdf<propto__>(treat_e, mu_treate, sigma_treate));
        current_statement__ = 15;
        lp_accum__.add(normal_lpdf<propto__>(U_e, mu_ue, sigma_ue));
        current_statement__ = 16;
        lp_accum__.add(normal_lpdf<propto__>(Z_e, mu_ze, sigma_ze));
        current_statement__ = 38;
        for (int i = 1; i <= N; ++i) {
          current_statement__ = 36;
          if ((primitive_value(logical_eq(treat[(i - 1)], 0)) &&
              primitive_value(logical_eq(direct[(i - 1)], 0)))) {
            current_statement__ = 34;
            lp_accum__.add(
              stan::math::log(
                (((stan::math::exp(
                     jd(
                       inv_logit(
                         multiply(
                           rvalue(X,
                             cons_list(index_uni(i),
                               cons_list(index_omni(), nil_index_list())),
                             "X"), gamma0)), pstream__)) *
                    stan::math::exp(
                      gd(
                        inv_logit(
                          multiply(
                            rvalue(X,
                              cons_list(index_uni(i),
                                cons_list(index_omni(), nil_index_list())),
                              "X"), delta)), pstream__))) *
                   stan::math::exp(
                     h1d(Y[(i - 1)], J,
                       ((inv_logit(
                           ((multiply(
                               rvalue(X,
                                 cons_list(index_uni(i),
                                   cons_list(index_omni(), nil_index_list())),
                                 "X"), psi0) + Z_e) + U_e)) * (1 - rho0)) /
                         rho0),
                       (((1 -
                           inv_logit(
                             ((multiply(
                                 rvalue(X,
                                   cons_list(index_uni(i),
                                     cons_list(index_omni(),
                                       nil_index_list())), "X"), psi0) + Z_e)
                               + U_e))) * (1 - rho0)) / rho0), pstream__))) +
                  ((1 -
                     stan::math::exp(
                       gd(
                         inv_logit(
                           multiply(
                             rvalue(X,
                               cons_list(index_uni(i),
                                 cons_list(index_omni(), nil_index_list())),
                               "X"), delta)), pstream__))) *
                    stan::math::exp(
                      h0d(Y[(i - 1)], J,
                        ((inv_logit(
                            multiply(
                              rvalue(X,
                                cons_list(index_uni(i),
                                  cons_list(index_omni(), nil_index_list())),
                                "X"), psi0)) * (1 - rho0)) / rho0),
                        (((1 -
                            inv_logit(
                              multiply(
                                rvalue(X,
                                  cons_list(index_uni(i),
                                    cons_list(index_omni(), nil_index_list())),
                                  "X"), psi0))) * (1 - rho0)) / rho0), pstream__))))));
          } else {
            current_statement__ = 33;
            if ((primitive_value(logical_eq(treat[(i - 1)], 0)) &&
                primitive_value(logical_eq(direct[(i - 1)], 1)))) {
              current_statement__ = 31;
              lp_accum__.add(
                ((stan::math::log(
                    (1 -
                      stan::math::exp(
                        jd(
                          inv_logit(
                            multiply(
                              rvalue(X,
                                cons_list(index_uni(i),
                                  cons_list(index_omni(), nil_index_list())),
                                "X"), gamma0)), pstream__)))) +
                   gd(
                     inv_logit(
                       multiply(
                         rvalue(X,
                           cons_list(index_uni(i),
                             cons_list(index_omni(), nil_index_list())), "X"),
                         delta)), pstream__)) +
                  h1d(Y[(i - 1)], J,
                    ((inv_logit(
                        (multiply(
                           rvalue(X,
                             cons_list(index_uni(i),
                               cons_list(index_omni(), nil_index_list())),
                             "X"), psi0) + Z_e)) * (1 - rho0)) / rho0),
                    (((1 -
                        inv_logit(
                          (multiply(
                             rvalue(X,
                               cons_list(index_uni(i),
                                 cons_list(index_omni(), nil_index_list())),
                               "X"), psi0) + Z_e))) * (1 - rho0)) / rho0), pstream__)));
            } else {
              current_statement__ = 30;
              if ((primitive_value((primitive_value(
                  logical_eq(treat[(i - 1)], 1)) && primitive_value(
                  logical_eq(direct[(i - 1)], 0)))) && primitive_value(
                  logical_eq(Y[(i - 1)], 0)))) {
                current_statement__ = 28;
                lp_accum__.add(
                  (stan::math::log(
                     (1 -
                       stan::math::exp(
                         gd(
                           inv_logit(
                             multiply(
                               rvalue(X,
                                 cons_list(index_uni(i),
                                   cons_list(index_omni(), nil_index_list())),
                                 "X"), delta)), pstream__)))) +
                    h0d(0, J,
                      ((inv_logit(
                          multiply(
                            rvalue(X,
                              cons_list(index_uni(i),
                                cons_list(index_omni(), nil_index_list())),
                              "X"), psi0)) * (1 - rho0)) / rho0),
                      (((1 -
                          inv_logit(
                            multiply(
                              rvalue(X,
                                cons_list(index_uni(i),
                                  cons_list(index_omni(), nil_index_list())),
                                "X"), psi0))) * (1 - rho0)) / rho0), pstream__)));
              } else {
                current_statement__ = 27;
                if ((primitive_value((primitive_value(
                    logical_eq(treat[(i - 1)], 1)) && primitive_value(
                    logical_eq(direct[(i - 1)], 0)))) && primitive_value(
                    logical_eq(Y[(i - 1)], (J + 1))))) {
                  current_statement__ = 25;
                  lp_accum__.add(
                    ((jd(
                        inv_logit(
                          (multiply(
                             rvalue(X,
                               cons_list(index_uni(i),
                                 cons_list(index_omni(), nil_index_list())),
                               "X"), gamma0) + treat_e)), pstream__) +
                       gd(
                         inv_logit(
                           multiply(
                             rvalue(X,
                               cons_list(index_uni(i),
                                 cons_list(index_omni(), nil_index_list())),
                               "X"), delta)), pstream__)) +
                      h1d(J, J,
                        ((inv_logit(
                            ((multiply(
                                rvalue(X,
                                  cons_list(index_uni(i),
                                    cons_list(index_omni(), nil_index_list())),
                                  "X"), psi0) + Z_e) + U_e)) * (1 - rho0)) /
                          rho0),
                        (((1 -
                            inv_logit(
                              ((multiply(
                                  rvalue(X,
                                    cons_list(index_uni(i),
                                      cons_list(index_omni(),
                                        nil_index_list())), "X"), psi0) +
                                 Z_e) + U_e))) * (1 - rho0)) / rho0), pstream__)));
                } else {
                  current_statement__ = 24;
                  if ((primitive_value(logical_eq(treat[(i - 1)], 1)) &&
                      primitive_value(logical_eq(direct[(i - 1)], 0)))) {
                    current_statement__ = 22;
                    lp_accum__.add(
                      stan::math::log(
                        (((stan::math::exp(
                             jd(
                               inv_logit(
                                 (multiply(
                                    rvalue(X,
                                      cons_list(index_uni(i),
                                        cons_list(index_omni(),
                                          nil_index_list())), "X"), gamma0) +
                                   treat_e)), pstream__)) *
                            stan::math::exp(
                              gd(
                                inv_logit(
                                  multiply(
                                    rvalue(X,
                                      cons_list(index_uni(i),
                                        cons_list(index_omni(),
                                          nil_index_list())), "X"), delta)), pstream__)))
                           *
                           stan::math::exp(
                             h1d((Y[(i - 1)] - 1), J,
                               ((inv_logit(
                                   ((multiply(
                                       rvalue(X,
                                         cons_list(index_uni(i),
                                           cons_list(index_omni(),
                                             nil_index_list())), "X"), psi0)
                                      + Z_e) + U_e)) * (1 - rho0)) / rho0),
                               (((1 -
                                   inv_logit(
                                     ((multiply(
                                         rvalue(X,
                                           cons_list(index_uni(i),
                                             cons_list(index_omni(),
                                               nil_index_list())), "X"),
                                         psi0) + Z_e) + U_e))) * (1 - rho0))
                                 / rho0), pstream__))) +
                          ((1 -
                             stan::math::exp(
                               gd(
                                 inv_logit(
                                   multiply(
                                     rvalue(X,
                                       cons_list(index_uni(i),
                                         cons_list(index_omni(),
                                           nil_index_list())), "X"), delta)), pstream__)))
                            *
                            stan::math::exp(
                              h0d(Y[(i - 1)], J,
                                ((inv_logit(
                                    multiply(
                                      rvalue(X,
                                        cons_list(index_uni(i),
                                          cons_list(index_omni(),
                                            nil_index_list())), "X"), psi0))
                                   * (1 - rho0)) / rho0),
                                (((1 -
                                    inv_logit(
                                      multiply(
                                        rvalue(X,
                                          cons_list(index_uni(i),
                                            cons_list(index_omni(),
                                              nil_index_list())), "X"), psi0)))
                                   * (1 - rho0)) / rho0), pstream__))))));
                  } else {
                    current_statement__ = 21;
                    if ((primitive_value((primitive_value(
                        logical_eq(treat[(i - 1)], 1)) && primitive_value(
                        logical_eq(direct[(i - 1)], 1)))) && primitive_value(
                        logical_gt(Y[(i - 1)], 0)))) {
                      current_statement__ = 19;
                      lp_accum__.add(
                        ((stan::math::log(
                            (1 -
                              stan::math::exp(
                                jd(
                                  inv_logit(
                                    (multiply(
                                       rvalue(X,
                                         cons_list(index_uni(i),
                                           cons_list(index_omni(),
                                             nil_index_list())), "X"),
                                       gamma0) + treat_e)), pstream__)))) +
                           gd(
                             inv_logit(
                               multiply(
                                 rvalue(X,
                                   cons_list(index_uni(i),
                                     cons_list(index_omni(),
                                       nil_index_list())), "X"), delta)), pstream__))
                          +
                          h1d((Y[(i - 1)] - 1), J,
                            ((inv_logit(
                                (multiply(
                                   rvalue(X,
                                     cons_list(index_uni(i),
                                       cons_list(index_omni(),
                                         nil_index_list())), "X"), psi0) +
                                  Z_e)) * (1 - rho0)) / rho0),
                            (((1 -
                                inv_logit(
                                  (multiply(
                                     rvalue(X,
                                       cons_list(index_uni(i),
                                         cons_list(index_omni(),
                                           nil_index_list())), "X"), psi0) +
                                    Z_e))) * (1 - rho0)) / rho0), pstream__)));
                    } else {
                      current_statement__ = 17;
                      lp_accum__.add(1);
                    }
                  }
                }
              }
            }
          }}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_model_misreport_doublelist_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      Eigen::Matrix<double, -1, 1> psi0;
      psi0 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(psi0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      psi0 = in__.vector(K);
      Eigen::Matrix<double, -1, 1> delta;
      delta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(delta, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      delta = in__.vector(K);
      Eigen::Matrix<double, -1, 1> gamma0;
      gamma0 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(gamma0, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      gamma0 = in__.vector(K);
      double treat_e;
      treat_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      treat_e = in__.scalar();
      double U_e;
      U_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      U_e = in__.scalar();
      double Z_e;
      Z_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      Z_e = in__.scalar();
      double rho0;
      rho0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      rho0 = in__.scalar();
      current_statement__ = 7;
      rho0 = stan::math::lub_constrain(rho0, 0, 1);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(psi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(delta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(gamma0[(sym1__ - 1)]);}
      vars__.emplace_back(treat_e);
      vars__.emplace_back(U_e);
      vars__.emplace_back(Z_e);
      vars__.emplace_back(rho0);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      Eigen::Matrix<double, -1, 1> psi0;
      psi0 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(psi0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> psi0_flat__;
        current_statement__ = 1;
        assign(psi0_flat__, nil_index_list(), context__.vals_r("psi0"),
          "assigning variable psi0_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 1;
          assign(psi0, cons_list(index_uni(sym1__), nil_index_list()),
            psi0_flat__[(pos__ - 1)], "assigning variable psi0");
          current_statement__ = 1;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> delta;
      delta = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(delta, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> delta_flat__;
        current_statement__ = 2;
        assign(delta_flat__, nil_index_list(), context__.vals_r("delta"),
          "assigning variable delta_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 2;
          assign(delta, cons_list(index_uni(sym1__), nil_index_list()),
            delta_flat__[(pos__ - 1)], "assigning variable delta");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> gamma0;
      gamma0 = Eigen::Matrix<double, -1, 1>(K);
      stan::math::fill(gamma0, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> gamma0_flat__;
        current_statement__ = 3;
        assign(gamma0_flat__, nil_index_list(), context__.vals_r("gamma0"),
          "assigning variable gamma0_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
          current_statement__ = 3;
          assign(gamma0, cons_list(index_uni(sym1__), nil_index_list()),
            gamma0_flat__[(pos__ - 1)], "assigning variable gamma0");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      double treat_e;
      treat_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      treat_e = context__.vals_r("treat_e")[(1 - 1)];
      double U_e;
      U_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 5;
      U_e = context__.vals_r("U_e")[(1 - 1)];
      double Z_e;
      Z_e = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 6;
      Z_e = context__.vals_r("Z_e")[(1 - 1)];
      double rho0;
      rho0 = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      rho0 = context__.vals_r("rho0")[(1 - 1)];
      double rho0_free__;
      rho0_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 7;
      rho0_free__ = stan::math::lub_free(rho0, 0, 1);
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(psi0[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(delta[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
        vars__.emplace_back(gamma0[(sym1__ - 1)]);}
      vars__.emplace_back(treat_e);
      vars__.emplace_back(U_e);
      vars__.emplace_back(Z_e);
      vars__.emplace_back(rho0_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("psi0");
    names__.emplace_back("delta");
    names__.emplace_back("gamma0");
    names__.emplace_back("treat_e");
    names__.emplace_back("U_e");
    names__.emplace_back("Z_e");
    names__.emplace_back("rho0");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(K)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma0" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "treat_e");
    param_names__.emplace_back(std::string() + "U_e");
    param_names__.emplace_back(std::string() + "Z_e");
    param_names__.emplace_back(std::string() + "rho0");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "psi0" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "delta" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= K; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "gamma0" + '.' + std::to_string(sym1__));
      }}
    param_names__.emplace_back(std::string() + "treat_e");
    param_names__.emplace_back(std::string() + "U_e");
    param_names__.emplace_back(std::string() + "Z_e");
    param_names__.emplace_back(std::string() + "rho0");
    if (emit_transformed_parameters__) {
      
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"psi0\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"gamma0\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"treat_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"U_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"Z_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"rho0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"psi0\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"delta\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"gamma0\",\"type\":{\"name\":\"vector\",\"length\":" << K << "},\"block\":\"parameters\"},{\"name\":\"treat_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"U_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"Z_e\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"rho0\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_model_misreport_doublelist_namespace::model_model_misreport_doublelist;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_model_misreport_doublelist_namespace::profiles__;
}
#endif
#endif
