% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql-query-execution.R
\name{db_sql_fetch_results}
\alias{db_sql_fetch_results}
\title{Fetch SQL Query Results from Completed Query}
\usage{
db_sql_fetch_results(
  statement_id,
  manifest,
  return_arrow = FALSE,
  max_active_connections = 30,
  fetch_timeout = 300,
  row_limit = NULL,
  host = db_host(),
  token = db_token(),
  show_progress = TRUE
)
}
\arguments{
\item{statement_id}{Query statement ID}

\item{manifest}{Query result manifest from status response}

\item{return_arrow}{Boolean, return arrow Table instead of tibble}

\item{max_active_connections}{Integer for concurrent downloads}

\item{fetch_timeout}{Integer, timeout in seconds for downloading each result chunk}

\item{row_limit}{Integer, limit number of rows returned (applied after fetch)}

\item{host}{Databricks host}

\item{token}{Databricks token}

\item{show_progress}{If TRUE, show progress updates during result fetching (default: TRUE)}
}
\value{
tibble or arrow Table with query results
}
\description{
Internal helper that fetches and processes results from a completed query.
Handles Arrow stream processing and data conversion.
}
\keyword{internal}
