% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_kernel_funcs.R
\name{box_pred_kernel}
\alias{box_pred_kernel}
\title{Box predation kernel}
\usage{
box_pred_kernel(ppmr, ppmr_min, ppmr_max)
}
\arguments{
\item{ppmr}{A vector of predator/prey size ratios}

\item{ppmr_min}{Minimum predator/prey mass ratio}

\item{ppmr_max}{Maximum predator/prey mass ratio}
}
\value{
A vector giving the value of the predation kernel at each of the
predator/prey mass ratios in the \code{ppmr} argument.
}
\description{
A predation kernel where the predator/prey mass ratio is uniformly
distributed on an interval.
}
\details{
Writing the predator mass as \eqn{w} and the prey mass as \eqn{w_p}, the
feeding kernel is 1 if \eqn{w/w_p} is between \code{ppmr_min} and
\code{ppmr_max} and zero otherwise. The parameters need to be given in the
species parameter dataframe in the columns \code{ppmr_min} and
\code{ppmr_max}.
}
\examples{
params <- NS_params
# Set all required paramters before changing kernel type
species_params(params)$ppmr_max <- 4000
species_params(params)$ppmr_min <- 200
species_params(params)$pred_kernel_type <- "box"
plot(w_full(params), getPredKernel(params)["Cod", 10, ], type="l", log="x")
}
\seealso{
\code{\link[=setPredKernel]{setPredKernel()}}

Other predation kernel: 
\code{\link{lognormal_pred_kernel}()},
\code{\link{power_law_pred_kernel}()},
\code{\link{truncated_lognormal_pred_kernel}()}
}
\concept{predation kernel}
