% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MizerParams-class.R
\name{validParams}
\alias{validParams}
\title{Validate MizerParams object and upgrade if necessary}
\usage{
validParams(params)
}
\arguments{
\item{params}{The MizerParams object to validate}
}
\value{
A valid MizerParams object
}
\description{
Checks that the given MizerParams object is valid and upgrades it if
necessary.
}
\details{
It is possible to render a MizerParams object invalid by manually changing
its slots. This function checks that the object is valid and if not it
attempts to upgrade it to a valid object or gives an error message. If the
object is valid then it is returned unchanged. The function reports an error
if any of the rate arrays contain any non-finite numbers (except for the
maximum intake rate that is allowed to be infinite).

Occasionally, during the development of new features for mizer, the
\linkS4class{MizerParams} object gains extra slots. MizerParams objects
created in older versions of mizer are then no longer valid in the new
version because of the missing slots. You need to upgrade them with this
function. It adds the missing slots and fills them with default values. Any
object from version 0.4 onwards can be upgraded. Any old
\linkS4class{MizerSim} objects should be similarly updated with
\code{\link[=validSim]{validSim()}}.

This function uses \code{\link[=newMultispeciesParams]{newMultispeciesParams()}} to create a new
MizerParams object using the parameters extracted from the old MizerParams
object.

Besides upgrading, if necessary, the only changes that may be made to the
given MizerParams object is that the \code{w_min_idx} and \code{ft_mask} slots are
recalculated.
}
\section{Backwards compatibility}{

The internal numerics in mizer have changed over time, so there may be small
discrepancies between the results obtained with the upgraded object
in the new version and the original object in the old version. If it
is important for you to reproduce the exact results then you should install
the version of mizer with which you obtained the results. You can do this
with

\if{html}{\out{<div class="sourceCode">}}\preformatted{remotes::install_github("sizespectrum/mizer", ref = "v0.2")
}\if{html}{\out{</div>}}

where you should replace "v0.2" with the version number you require. You can
see the list of available releases at
\url{https://github.com/sizespectrum/mizer/tags}.

If you only have a serialised version of the old object, for example
created via \code{\link[=saveRDS]{saveRDS()}}, and you get an error when trying to read it in
with \code{\link[=readRDS]{readRDS()}} then unfortunately you will need to install the old version
of mizer first to read the params object into your workspace, then switch
to the current version and then call \code{\link[=validParams]{validParams()}}. You can then save
the new version again with \code{\link[=saveParams]{saveParams()}}.
}

