% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour_vrt.R
\name{vector_vrt}
\alias{vector_vrt}
\title{Vector VRT}
\usage{
vector_vrt(x, layer = 1L, projection = NULL, sql = NULL, a_srs = NULL)
}
\arguments{
\item{x}{data source name}

\item{layer}{layer index (1-based) or name}

\item{projection}{crs of the output}

\item{sql}{SQL for ExecuteSQL to define the layer}

\item{a_srs}{set the source crs}
}
\value{
single element character vector
}
\description{
Just a simple text generator to generate the VRT for a vector layer, First layer is chosen if not
otherwise specified.
}
\details{
Using 'sql' overrides the 'layer', and using 'projection' results in the geometries being transformed.
No check is made of the layer source projection.

Use 'a_srs' to ensure the source has a source crs (that might be the only thing you use this for, even if not reprojecting).

It's expected that if you use this with a source without a source projection,
you'll get "Failed to import source SRS", so use argument "a_srs" to set it
if needed (or many other GDAL other facilities that do this).
}
\examples{
file <- "list_locality_postcode_meander_valley.tab"
## A MapInfo TAB file with polygons
mvfile <- system.file(file.path("extdata/tab", file), package="vapour")
vector_vrt(mvfile, sql = "SELECT * FROM list_locality_postcode_meander_valley LIMIT 5 OFFSET 4")

## read this with vapour_read_geometry() and it will be projected to VicGrid
vector_vrt(mvfile, projection = "EPSG:3111")

}
