% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unanimitygame.R
\name{unanimitygame}
\alias{unanimitygame}
\title{Unanimity game}
\usage{
unanimitygame(n, S, binary = FALSE)
}
\arguments{
\item{n}{Number of players, as an integer.}

\item{S}{The position of a coalition, as an integer.}

\item{binary}{A logical value. By default, \code{binary=FALSE}. Should be set to \code{TRUE} if \code{S} is introduced according to binary order instead of lexicographic order.}
}
\value{
The characteristic function of the unanimity game of coalition \code{S}, as a vector in binary order if \code{binary=TRUE} and in lexicographic order otherwise.
}
\description{
This function returns the characteristic function of the unanimity game of a coalition.
}
\details{
The characteristic function of the unanimity game of a coalition \eqn{S\in 2^N}
is defined, for each \eqn{R\in 2^N}, as \eqn{u_S(R)=1} if \eqn{S\subset R} and \eqn{u_S(R)=0} otherwise.
}
\examples{
unanimitygame(n=4,S=7)
}
