% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fast.gtest.R
\name{fast.gtest}
\alias{fast.gtest}
\title{Fast Zero-Tolerant G-Test of Association}
\usage{
fast.gtest(x, y, log.p = FALSE)
}
\arguments{
\item{x}{a vector to 
specify observations of the first 
categorical variable. The vector can be of
numeric, character, or logical type.
\code{NA} values must be removed or
replaced before calling the function.}

\item{y}{a vector to specify observations of 
the second categorical variable. 
  Must not contain \code{NA} values and 
  must be of the same length as \code{x}.}

\item{log.p}{a logical. If \code{TRUE}, 
the \emph{p}-value is calculated in
closed form to \strong{natural logarithm} of \emph{p}-value 
to improve numerical precision when
\emph{p}-value approaches zero.
Defaults to \code{FALSE}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\item{statistic}{the \emph{G}-test statistic (Likelihood Ratio Chi-squared statistic).}
\item{parameter}{the degrees of freedom.}
\item{p.value}{the \emph{p}-value of the test.}
\item{estimate}{the mutual information between the two variables.}
\item{method}{a character string indicating the method used.}
\item{data.name}{a character string giving the names of the data.}
}
\description{
Performs a fast zero-tolerant 
\emph{G}-test \insertCite{WOOLF:1957aa}{Upsilon}
to evaluate association between observations 
from two categorical variables.
}
\note{
The test uses an internal 
  hash table, instead of matrix, to
  store the contingency table. Savings in 
  both runtime and memory saving can be
  substantial if the contingency table is 
  sparse and large. The test is implemented
  in C++, to give an additional layer of
  speedup over an R implementation.
}
\examples{
library("Upsilon")
weather <- c(
  "rainy", "sunny", "rainy", "sunny", "rainy"
)
mood <- c(
  "wistful", "upbeat", "upbeat", "upbeat", "wistful"
)

fast.gtest(weather, mood)

# The result is equivalent to: 
modified.gtest(table(weather, mood))
}
\references{
\insertRef{WOOLF:1957aa}{Upsilon}
}
