% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_analysis_sc.R
\name{get_string_network}
\alias{get_string_network}
\title{Download and Process STRING Protein-Protein Interaction Network}
\usage{
get_string_network(
  organism = "9606",
  score_threshold = 700,
  use_default = TRUE
)
}
\arguments{
\item{organism}{Character string specifying the NCBI taxonomy identifier.
Default is "9606" (Homo sapiens).}

\item{score_threshold}{Numeric value between 0 and 1000 specifying the minimum
combined score threshold for including interactions. Default is 700.}

\item{use_default}{it will return the default network (9606 and score of 700)}
}
\value{
An igraph object representing the largest connected component of
        the filtered STRING network, with the following properties:
        \itemize{
          \item Undirected edges
          \item No self-loops
          \item No multiple edges
          \item Edge weights (1000 - combined_score)
          \item Vertex names as ENTREZ IDs
        }
}
\description{
Downloads and processes the STRING protein-protein interaction network,
converting it to a simplified igraph object. The function downloads the
network from STRING database, filters interactions by confidence score,
converts STRING IDs to ENTREZ IDs, and returns the largest connected
component as an undirected graph.
}
\details{
The function performs the following steps:
\enumerate{
  \item Downloads protein interactions from STRING database
  \item Filters interactions based on combined score
  \item Downloads and processes STRING ID to ENTREZ ID mappings
  \item Creates an igraph object with filtered interactions
  \item Removes self-loops and multiple edges
  \item Extracts the largest connected component
}
}
