% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PKNCA.R
\name{ensure_column_unit_exists}
\alias{ensure_column_unit_exists}
\title{Ensure Unit Columns Exist in PKNCA Object}
\usage{
ensure_column_unit_exists(pknca_obj, unit_name)
}
\arguments{
\item{pknca_obj}{A PKNCA object (either PKNCAconc or PKNCAdose).}

\item{unit_name}{A character vector of unit column names to ensure (concu, amountu, timeu...).}
}
\value{
The updated PKNCA object with ensured unit columns.
}
\description{
Checks if specified unit columns exist in a PKNCA object (either PKNCAconc or PKNCAdose).
If the columns do not exist, it creates them and assigns default values (NA or existing units).
}
\details{
The function performs the following steps:
\enumerate{
\item Checks if the specified unit columns exist in the PKNCA object.
\item If a column does not exist, it creates the column and assigns default values.
\item If not default values are provided, it assigns NA to the new column.
}
}
