% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/masks.R
\name{masks}
\alias{masks}
\alias{reproduction}
\alias{survival}
\alias{transition}
\alias{all_cells}
\alias{all_classes}
\alias{combine}
\title{Isolate elements of population dynamics models}
\usage{
reproduction(matrix, dims = NULL)

survival(matrix, dims = NULL)

transition(matrix, dims = NULL)

all_cells(matrix, dims = NULL)

all_classes(matrix, dims = NULL)

combine(...)
}
\arguments{
\item{matrix}{a population dynamics matrix for which
a particular mask is required. Only used to determine
mask dimensions, so can be any matrix with appropriate
dimensions}

\item{dims}{a numeric value or vector identifying
subsets of cells to include in a given mask}

\item{\dots}{a set of masks or masking functions
to be combined into a single mask by one of the
\code{combine} methods}
}
\value{
\code{mask} object used to define the cells affected by
  a process included in \code{\link{dynamics}}
}
\description{
Helper functions to isolate particular components
  of a population dynamics model, such as the reproduction terms,
  transition/growth terms, or particular life stages from an
  abundance vector, such as pre- or post-reproductive stages.
}
\examples{
# define a population
nclass <- 5
popmat <- matrix(0, nrow = nclass, ncol = nclass)
popmat[reproduction(popmat, dims = 4:5)] <- c(10, 20)
popmat[transition(popmat)] <- c(0.25, 0.3, 0.5, 0.65)

# pull out reproductive elements
reproduction(popmat)

# what if only 4 and 5 year olds reproduce?
reproduction(popmat, dims = 4:5)

# define survival elements
survival(popmat)

# what if 1 and 2 year olds always transition?
survival(popmat, dims = 3:5)

# and transitions
transition(popmat)

# combine transitions and reproduction of 4 and 5 year olds
combine(reproduction(popmat, dims = 4:5), transition(popmat))

# can also mask the population vector in this way
# pull out all classes
all_classes(popmat)

# and just 3-5 year olds
all_classes(popmat, dims = 3:5)
}
