% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mixture.R
\name{cdf.mixture}
\alias{cdf.mixture}
\title{Cumulative distribution function for a mixture distribution.}
\usage{
\method{cdf}{mixture}(x, ...)
}
\arguments{
\item{x}{A \code{mixture} object.}

\item{...}{Additional arguments (not used).}
}
\value{
A function \code{function(q, ...)} returning the CDF at \code{q}.
}
\description{
Returns a function that evaluates the mixture CDF at given points.
The mixture CDF is \eqn{F(x) = \sum_k w_k F_k(x)}.
}
\examples{
m <- mixture(list(normal(0, 1), normal(5, 1)), c(0.5, 0.5))
F <- cdf(m)
F(0)
F(5)
}
