% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poisson_dist.R
\name{poisson_dist}
\alias{poisson_dist}
\title{Construct a Poisson distribution object.}
\usage{
poisson_dist(lambda)
}
\arguments{
\item{lambda}{Rate parameter (mean), must be a positive scalar.}
}
\value{
A \code{poisson_dist} object with classes
\code{c("poisson_dist", "univariate_dist", "discrete_dist", "dist")}.
}
\description{
Creates an S3 object representing a Poisson distribution with rate
parameter \eqn{\lambda}.  The PMF is
\eqn{P(X = k) = \lambda^k e^{-\lambda} / k!} for \eqn{k = 0, 1, 2, \ldots}.
}
\examples{
x <- poisson_dist(lambda = 5)
mean(x)
vcov(x)
format(x)
}
