% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realize.R
\name{realize}
\alias{realize}
\alias{realize.dist}
\alias{realize.empirical_dist}
\alias{realize.realized_dist}
\title{Materialize any distribution to empirical_dist by sampling.}
\usage{
realize(x, n = 10000, ...)

\method{realize}{dist}(x, n = 10000, ...)

\method{realize}{empirical_dist}(x, ...)

\method{realize}{realized_dist}(x, n = 10000, ...)
}
\arguments{
\item{x}{A distribution object (inheriting from \code{dist}).}

\item{n}{Number of samples (default: 10000).}

\item{...}{Additional arguments passed to methods.}
}
\value{
An \code{\link{empirical_dist}} (or \code{\link{realized_dist}})
object.
}
\description{
\code{realize} draws \code{n} samples from a distribution and wraps
them in an \code{\link{empirical_dist}}.
This is the universal fallback that lets any \code{dist} object be
converted to a discrete approximation on which methods like
\code{\link{cdf}}, \code{\link{density}}, and \code{\link{conditional}}
are always available.
}
\details{
For non-empirical distributions, the result is a
\code{\link{realized_dist}} that preserves the source distribution
as provenance metadata.  This enables re-sampling via
\code{realize(x$source, n = ...)} and informative printing.

The \code{empirical_dist} method is a no-op: the distribution is
already materialized.

The \code{realized_dist} method re-samples from the original source
distribution, allowing cheap regeneration with a different sample size.
}
\examples{
\donttest{
set.seed(1)
x <- normal(0, 1)
rd <- realize(x, n = 1000)
mean(rd)
}
}
