% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algebra.R
\name{simplify.edist}
\alias{simplify.edist}
\title{Method for simplifying an \code{edist} object.}
\usage{
\method{simplify}{edist}(x, ...)
}
\arguments{
\item{x}{The \code{edist} object to simplify}

\item{...}{Additional arguments to pass (not used)}
}
\value{
The simplified distribution, or unchanged \code{edist} if no rule applies
}
\description{
Attempts to reduce expression distributions to closed-form distributions
when mathematical identities apply. Supported rules include:
}
\details{
Single-variable:
\itemize{
\item c * Normal(mu, v) -> Normal(c\emph{mu, c^2}v)
\item c * Gamma(a, r) -> Gamma(a, r/c) for c > 0
\item c * Exponential(r) -> Gamma(1, r/c) for c > 0
\item c * Uniform(a, b) -> Uniform(min(ca,cb), max(ca,cb)) for c != 0
\item c * Weibull(k, lam) -> Weibull(k, c*lam) for c > 0
\item c * ChiSq(df) -> Gamma(df/2, 1/(2c)) for c > 0
\item c * LogNormal(ml, sl) -> LogNormal(ml + log(c), sl) for c > 0
\item Normal(mu, v) + c -> Normal(mu + c, v)
\item Normal(mu, v) - c -> Normal(mu - c, v)
\item Uniform(a, b) + c -> Uniform(a + c, b + c)
\item Uniform(a, b) - c -> Uniform(a - c, b - c)
\item Normal(0, 1) ^ 2 -> ChiSquared(1)
\item exp(Normal(mu, v)) -> LogNormal(mu, sqrt(v))
\item log(LogNormal(ml, sl)) -> Normal(ml, sl^2)
}

Two-variable:
\itemize{
\item Normal + Normal -> Normal
\item Normal - Normal -> Normal
\item Gamma + Gamma (same rate) -> Gamma
\item Exponential + Exponential (same rate) -> Gamma(2, rate)
\item Gamma + Exponential (same rate) -> Gamma(a+1, rate)
\item ChiSquared + ChiSquared -> ChiSquared
\item Poisson + Poisson -> Poisson
\item LogNormal * LogNormal -> LogNormal
}
}
\examples{
# Normal + Normal simplifies to a Normal
z <- normal(0, 1) + normal(2, 3)
is_normal(z)  # TRUE
z             # Normal(mu = 2, var = 4)

# exp(Normal) simplifies to LogNormal
w <- exp(normal(0, 1))
is_lognormal(w)  # TRUE
}
