% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonparTrawlEstimation.R
\name{test_asymnorm}
\alias{test_asymnorm}
\title{Computing the infeasible test statistic from the trawl function
estimation CLT}
\usage{
test_asymnorm(ahat, n, Delta, k, c4, varlevyseed = 1, trawlfct, trawlfct_par)
}
\arguments{
\item{ahat}{The term \eqn{\hat a(k \Delta_n)} in the CLT}

\item{n}{The number n of observations in the sample}

\item{Delta}{The width Delta of the observation grid}

\item{k}{The time point in \eqn{0, 1, \ldots, n-1};
the test statistic will be computed for the time point
\eqn{k*\Delta_n}.}

\item{c4}{The fourth cumulant of the Levy seed of the trawl process}

\item{varlevyseed}{The variance of the Levy seed of the trawl process,
the default is 1}

\item{trawlfct}{The trawl function for which the
asymptotic variance will be computed (Exp, supIG or LM)}

\item{trawlfct_par}{The parameter vector of the trawl function
(Exp: lambda, supIG: delta, gamma, LM: alpha, H)}
}
\value{
The function returns the infeasible test statistic specified above.
}
\description{
This function computes the infeasible test statistic appearing in the CLT
for the trawl function estimation.
}
\details{
As derived in
Sauri and Veraart (2022), the infeasible test statistic is given by
\deqn{\frac{\sqrt{n\Delta_{n}}}{\sqrt{\sigma_{a}^2(k \Delta_n)}}
\left(\hat{a}(k\Delta_n)-a(k \Delta_n)\right),}
for \eqn{k \in \{0, 1, \ldots, n-1\}}.
}
\examples{
test_asymnorm(ahat=0.9, n=5000, Delta=0.1, k=1, c4=1, varlevyseed=1,
              trawlfct="Exp", trawlfct_par=0.1)
}
