% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timeseries_enhanced.R
\name{anki_forecast_enhanced}
\alias{anki_forecast_enhanced}
\title{Enhanced Time Series Forecasting}
\usage{
anki_forecast_enhanced(
  path = NULL,
  profile = NULL,
  metric = "reviews",
  days_ahead = 30,
  method = "auto",
  confidence = 0.95,
  workload_ceiling = NULL
)
}
\arguments{
\item{path}{Path to collection.anki2 (auto-detected if NULL)}

\item{profile}{Profile name (first profile if NULL)}

\item{metric}{Metric to forecast: "reviews", "time", "retention", "cards_learned"}

\item{days_ahead}{Number of days to forecast (default 30)}

\item{method}{Forecasting method: "auto", "arima", "ets", "holt", "seasonal"}

\item{confidence}{Confidence level for prediction intervals (default 0.95)}

\item{workload_ceiling}{Maximum daily workload (NULL for none)}
}
\value{
A tibble with forecast results
}
\description{
Improved forecasting with ARIMA, seasonal patterns, and workload ceilings.
}
\examples{
\dontrun{
fc <- anki_forecast_enhanced("reviews", days_ahead = 30)
plot(fc$date, fc$forecast, type = "l")
}
}
