% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/district.R
\name{editDistrict}
\alias{editDistrict}
\title{Edit a district in an Antares study}
\usage{
editDistrict(
  name,
  caption = NULL,
  comments = NULL,
  apply_filter = NULL,
  add_area = NULL,
  remove_area = NULL,
  output = NULL,
  opts = simOptions()
)
}
\arguments{
\item{name}{District's name.}

\item{caption}{Caption for the district.}

\item{comments}{Comments for the district.}

\item{apply_filter}{Possible values are \code{add-all} to add all areas to the district,
\code{remove-all} to clear the district, or \code{none} (default) to don't apply a filter.}

\item{add_area}{Character vector of area(s) to add to the district.}

\item{remove_area}{Character vector of area(s) to remove from the district.}

\item{output}{Logical, compute the results for the district or not?}

\item{opts}{List of simulation parameters returned by the function
\code{\link[antaresRead:setSimulationPath]{antaresRead::setSimulationPath()}}}
}
\value{
An updated list containing various information about the simulation.
}
\description{
Edit a district in an Antares study
}
\examples{
\dontrun{
editDistrict(
  name = "my_existing_district",
  comments = "This is my district",
  add_area = c("area1", "area3", "area5"),
  opts = simOptions()
)
}
}
\seealso{
\code{\link[=createDistrict]{createDistrict()}}, \code{\link[=removeDistrict]{removeDistrict()}}
}
