% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asAntaresDataList.R
\name{as.antaresDataList}
\alias{as.antaresDataList}
\alias{as.antaresDataList.antaresDataTable}
\alias{as.antaresDataList.data.frame}
\title{Convert objects to antaresDataTable}
\usage{
as.antaresDataList(x, ...)

\method{as.antaresDataList}{antaresDataTable}(x, name = NULL, ...)

\method{as.antaresDataList}{data.frame}(
  x,
  synthesis,
  timeStep,
  type,
  opts = simOptions(),
  name = type,
  ...
)
}
\arguments{
\item{x}{Data.frame or data.table to convert to a an antaresDataTable.}

\item{...}{Arguments to be passed to methods.}

\item{name}{name of the table in the final object. If \code{NULL}, the type of the data
is used.}

\item{synthesis}{Does the table contain synthetic results ?}

\item{timeStep}{Time step of the data. One of "hourly", "daily", "weekly", "monthly" or "annual".}

\item{type}{type of data: for instance "areas", "links", "clusters", etc.}

\item{opts}{Simulation options.}
}
\value{
\code{antaresDataList} object.
}
\description{
This function converts a list of tables or table into an
\code{antaresDataList} object.

An \code{antaresDataList} is a list of tables of class\code{antaresDataTable}.
It also has attributes that store the time step, the type of data and the
simulation options.
}
