% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{cereal}
\alias{cereal}
\title{Breakfast Cereal Data Set}
\format{
A matrix containing 77 observations and 16 attributes.
\describe{
\item{\code{name}}{name of cereal}
\item{\code{manuf}}{manufacturer of cereal, coded into seven categories: "A" for American Home Food Products, "G" for General Mills, "K" for Kelloggs, "N" for Nabisco, "P" for Post, "Q" for Quaker Oats, and "R" for Ralston Purina}
\item{\code{type}}{cold or hot}
\item{\code{calories}}{calories per serving}
\item{\code{protein}}{grams of protein}
\item{\code{fat}}{grams of fat}
\item{\code{sodium}}{milligrams of sodium}
\item{\code{fiber}}{grams of dietary fiber}
\item{\code{carbo}}{grams of complex carbohydrates}
\item{\code{sugars}}{grams of sugars}
\item{\code{potass}}{milligrams of potassium}
\item{\code{vitamins}}{vitamins and minerals - 0, 25, or 100, indicating the typical percentage of FDA recommended}
\item{\code{shelf}}{display shelf (1, 2, or 3, counting from the floor)}
\item{\code{weight}}{weight in ounces of one serving}
\item{\code{cups}}{number of cups in one serving}
\item{\code{rating}}{a rating of the cereals}
}
}
\source{
https://lib.stat.cmu.edu/datasets/1993.expo/
}
\usage{
cereal
}
\description{
Nutritional information and manufacturer data for 70+ popular US breakfast cereals
}
\examples{
data(cereal)
str(cereal)
}
\references{
Reza Mohammadi (2025). Data Science Foundations and Machine
Learning with R: From Data to Decisions. \url{https://book-data-science-r.netlify.app}.
}
\keyword{datasets}
