% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aoe_area.R
\name{aoe_area}
\alias{aoe_area}
\title{Compute Area Statistics for AoE}
\usage{
aoe_area(x)
}
\arguments{
\item{x}{An \code{aoe_result} object returned by \code{\link[=aoe]{aoe()}}.}
}
\value{
An \code{aoe_area_result} data frame with one row per support:
\describe{
\item{support_id}{Support identifier}
\item{area_core}{Area of core region (same as original support)}
\item{area_halo}{Area of halo region (AoE minus core, after masking)}
\item{area_aoe}{Total AoE area after masking}
\item{halo_core_ratio}{Ratio of halo to core area (theoretically 3.0 without mask)}
\item{pct_masked}{Percentage of theoretical AoE area removed by masking}
}
}
\description{
Calculate area statistics for the original supports and their areas of
effect, including expansion ratios, masking effects, and core/halo balance.
}
\details{
With scale \eqn{s}, the AoE expands by multiplier \eqn{(1+s)} from centroid,
resulting in \eqn{(1+s)^2} times the area. The theoretical halo:core ratio
is \eqn{(1+s)^2 - 1}:
\itemize{
\item Scale 1 (default): ratio 3.0 (core 1 part, halo 3 parts)
\item Scale 0.414: ratio 1.0 (equal areas)
}

Masking reduces the halo (and thus the ratio) when the AoE extends beyond
hard boundaries.
}
\examples{
library(sf)

support <- st_as_sf(
  data.frame(id = 1),
  geometry = st_sfc(st_polygon(list(
    cbind(c(0, 10, 10, 0, 0), c(0, 0, 10, 10, 0))
  ))),
  crs = 32631
)

pts <- st_as_sf(
  data.frame(id = 1:3),
  geometry = st_sfc(
    st_point(c(5, 5)),
    st_point(c(15, 5)),
    st_point(c(2, 2))
  ),
  crs = 32631
)

result <- aoe(pts, support)
aoe_area(result)

}
