% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artma.R
\name{artma}
\alias{artma}
\title{Run meta-analysis with artma}
\usage{
artma(
  data = NULL,
  methods = NULL,
  options = NULL,
  options_dir = NULL,
  open_results = FALSE,
  ...
)
}
\arguments{
\item{data}{\emph{[data.frame, optional]} Data frame to analyze. If \code{NULL}, data will
be loaded from the options file (see \code{options} parameter). When provided, this
data will be used directly, bypassing the data reading step.}

\item{methods}{\emph{[character, optional]} A character vector of method names to run.
Use \code{"all"} to run all available methods. If \code{NULL}, an interactive menu will
prompt you to select methods. See \code{artma::methods.list()} for available methods.}

\item{options}{\emph{[character, optional]} Name of the options file (with or without
\code{.yaml} extension) to use. If \code{NULL} and running interactively, you will be
prompted to create or select an options file.}

\item{options_dir}{\emph{[character, optional]} Directory containing the options file.
If \code{NULL}, uses the default options directory.}

\item{open_results}{\emph{[logical, optional]} Whether to open the results directory
after exporting results. Defaults to \code{FALSE}.}

\item{...}{Additional arguments passed to the runtime methods.}
}
\value{
\emph{[list]} A named list containing results from each method, indexed by
method name. The structure of each result depends on the specific method.
}
\description{
Main entry point for the artma package. This function orchestrates the complete
meta-analysis workflow: loading options, preparing data, and running specified
analytical methods.
}
\details{
The \code{artma()} function is the primary way to interact with the artma package.
It handles the complete workflow:
\enumerate{
\item \strong{Options Loading}: Loads configuration from an options file (or prompts for
creation in interactive mode)
\item \strong{Data Preparation}: Reads and prepares your data (unless \code{data} is provided)
\item \strong{Method Execution}: Runs the specified analytical methods on your data
\item \strong{Results}: Returns a structured list of results
}
\subsection{Options Files}{

Options files are YAML configuration files that store all settings for your analysis,
including data paths, column mappings, method parameters, and output preferences.
They ensure reproducibility and make it easy to manage multiple analysis configurations.
}

\subsection{Methods}{

Methods are analytical functions that perform specific meta-analysis tasks (e.g.,
funnel plots, Bayesian Model Averaging, effect size calculations). You can run
multiple methods in a single call, and they will execute in a predefined order.
}

\subsection{Data Parameter}{

When \code{data} is provided, it bypasses the data reading step and uses your data frame
directly. The data will still be preprocessed and validated according to your
options configuration. This is useful when you already have data loaded in R or
want to analyze data programmatically.
}
}
\examples{
\dontrun{
# Interactive mode - will prompt for options and methods
results <- artma()

# Run specific methods with an options file
results <- artma(
  methods = c("funnel_plot", "bma", "fma"),
  options = "my_analysis.yaml"
)

# Run all methods
results <- artma(methods = "all", options = "my_analysis.yaml")

# Use data directly (bypasses file reading)
my_data <- data.frame(
  effect = c(0.5, 0.3, 0.7),
  se = c(0.1, 0.15, 0.12),
  study_id = c("Study A", "Study B", "Study C")
)
results <- artma(data = my_data, methods = "funnel_plot")

# Access results
funnel_result <- results$funnel_plot
}

}
\seealso{
\itemize{
\item \code{artma::methods.list()} - List available methods
\item \code{artma::options.create()} - Create a new options file
\item \code{artma::prepare_data()} - Prepare data manually
}
}
