% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_preview.R
\name{data.preview}
\alias{data.preview}
\title{Preview data}
\usage{
data.preview(
  data = NULL,
  options = NULL,
  options_dir = NULL,
  preprocess = TRUE
)
}
\arguments{
\item{data}{\emph{[character, data.frame, optional]} Either \code{NULL}, a
length-one character path to a data file, or a data frame. If \code{NULL},
data is loaded from the options file (you will be prompted to select or
create one in interactive mode).}

\item{options}{\emph{[character, optional]} Name of the options file (with or
without \code{.yaml} extension). If \code{NULL} and options are required,
you will be prompted in interactive mode.}

\item{options_dir}{\emph{[character, optional]} Directory containing the options
file. If \code{NULL}, uses the default options directory.}

\item{preprocess}{\emph{[logical, optional]} If \code{TRUE} (default), data is
run through the full pipeline (read, preprocess, compute) so the viewer
shows what runtime methods receive. If \code{FALSE}, only the raw file
read (for a path) or the given data frame is shown, without
options-dependent standardization or preprocessing.}
}
\value{
Invisible \code{NULL}. Opens the data in the standard R viewer
(\code{utils::View()}).
}
\description{
Open a data frame in R's viewer. Data can be supplied as a file path, a data
frame, or loaded from an options file (with the same prompt flow as
\code{artma()} when no options are given).
}
\details{
Three data sources are supported:
\itemize{
\item \strong{Path}: pass a length-one character path to a data file. With
\code{preprocess = FALSE}, the file is read without loading options
(raw read). With \code{preprocess = TRUE}, options are loaded and the
full pipeline is applied.
\item \strong{Data frame}: pass a data frame. With \code{preprocess = FALSE},
it is viewed as-is. With \code{preprocess = TRUE}, options are loaded
and preprocess + compute are applied before viewing.
\item \strong{NULL}: data comes from the chosen options file (same
"select or create options file" flow as \code{artma()} with empty
arguments). With \code{preprocess = TRUE} (default), the full pipeline
(read, preprocess, compute) is run. With \code{preprocess = FALSE}, only
the data as read from file (with column standardization from options) is
shown, without preprocessing or computed columns.
}

In non-interactive mode, when \code{data} is \code{NULL} and \code{options}
is \code{NULL}, no viewer is shown (consistent with \code{artma()}).
}
\examples{
\dontrun{
# Preview data from options file (prompts for file if NULL)
data.preview(options = "my_analysis.yaml")

# Preview raw file without loading options
data.preview("/path/to/data.csv", preprocess = FALSE)

# Preview preprocessed data from a path (uses options for standardization)
data.preview("/path/to/data.csv", options = "my_analysis.yaml")

# Preview a data frame as-is
data.preview(mtcars, preprocess = FALSE)
}

}
\seealso{
\itemize{
\item \code{\link{artma}} - Run meta-analysis methods
\item \code{prepare_data()} - Prepare data manually
\item \code{\link{options.load}} - Load options
}
}
