% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/observer.R
\name{astro_observer_state}
\alias{astro_observer_state}
\title{Observer position and velocity vector from geographic coordinates}
\usage{
astro_observer_state(time, latitude, longitude, height, of_date = FALSE)
}
\arguments{
\item{time}{A POSIXct date and time for which to calculate the observer's state vector.}

\item{latitude}{The geographic latitude of the observer in degrees north of the equator
(range: -90 to +90).}

\item{longitude}{The geographic longitude of the observer in degrees east of the prime meridian
(range: 0 to 360 or -180 to +180).}

\item{height}{The elevation of the observer above sea level in meters.}

\item{of_date}{Logical. If \code{TRUE}, uses equator-of-date coordinates (Earth's equator at the
given time). If \code{FALSE} (default), uses J2000 coordinates (Earth's equator on 2000-01-01).}
}
\value{
A list with components:
\describe{
\item{x}{Equatorial x-coordinate in AU}
\item{y}{Equatorial y-coordinate in AU}
\item{z}{Equatorial z-coordinate in AU}
\item{vx}{Equatorial x-velocity in AU/day}
\item{vy}{Equatorial y-velocity in AU/day}
\item{vz}{Equatorial z-velocity in AU/day}
\item{t}{The time (POSIXct) at which the state vector is valid}
\item{status}{Status code (0 = success)}
}

The position vector components are expressed in Astronomical Units (AU).
Multiply by #KM_PER_AU to convert to kilometers. The velocity components
are in AU per day.

If only position is needed without velocity, \code{\link[=astro_observer_vector]{astro_observer_vector()}} is slightly
more efficient.
}
\description{
Calculates the geocentric equatorial position and velocity vectors of an observer
on the surface of the Earth, taking into account the Earth's rotation.
}
\examples{
# Get observer state at Sydney Observatory
time <- as.POSIXct("2024-01-01 12:00:00", tz = "UTC")
obs_state <- astro_observer_state(time, latitude = -33.8688, longitude = 151.2093, height = 0)
obs_state
}
