% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{am_length}
\alias{am_length}
\title{Get the length of an Automerge map or list}
\usage{
am_length(doc, obj)
}
\arguments{
\item{doc}{An Automerge document}

\item{obj}{An Automerge object ID, or \code{AM_ROOT} for the document root}
}
\value{
Integer length/size
}
\description{
Returns the number of key-value pairs in a map or elements in a list.
}
\examples{
doc <- am_create()

am_put(doc, AM_ROOT, "a", 1)
am_put(doc, AM_ROOT, "b", 2)

len <- am_length(doc, AM_ROOT)
len  # 2

am_close(doc)

}
