% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cursors.R
\name{am_cursor_to_string}
\alias{am_cursor_to_string}
\title{Serialize a cursor to a string}
\usage{
am_cursor_to_string(cursor)
}
\arguments{
\item{cursor}{An \code{am_cursor} object created by \code{\link[=am_cursor]{am_cursor()}}}
}
\value{
A character string containing the serialized cursor
}
\description{
Converts a cursor to a string representation that can be persisted
and later restored with \code{\link[=am_cursor_from_string]{am_cursor_from_string()}}.
}
\examples{
doc <- am_create()
am_put(doc, AM_ROOT, "text", am_text("Hello World"))
text_obj <- am_get(doc, AM_ROOT, "text")

cursor <- am_cursor(text_obj, 5)
str <- am_cursor_to_string(cursor)
str

# Restore cursor later
restored <- am_cursor_from_string(str, text_obj)
am_cursor_position(restored)  # 5

am_close(doc)

}
\seealso{
\code{\link[=am_cursor_from_string]{am_cursor_from_string()}}, \code{\link[=am_cursor_to_bytes]{am_cursor_to_bytes()}}
}
