% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ggstrat_samples}
\alias{ggstrat_samples}
\title{A combined grainsize-depth and sample label stratigraphic plot}
\usage{
ggstrat_samples(
  df,
  section_name,
  label = "stratlayer_sample",
  use_theme = NULL,
  ylim = NULL,
  depth_units = c("cm", "m"),
  ybreaks = 7
)
}
\arguments{
\item{df}{A data frame containing stratigraphic data.
Must include columns \code{stratsection_name}, \code{stratlayer_order},
\code{grainsize}, \code{depth}, \code{stratlayer_type}, and \code{SampleID}.}

\item{section_name}{Character string giving the section name to filter "stratsection_name".}

\item{label}{Character strin gnaming the column to use for labels. Default is "SampleID".}

\item{use_theme}{A ggplot2 theme object to apply to the plot, e.g., "theme_avstrat".}

\item{ylim}{Numeric vector of length 2 giving y-axis limits (optional).}

\item{depth_units}{Units to use for depth (y-axis) scale, either "cm" (default) or "m".}

\item{ybreaks}{Number of breaks on the y-axis.}
}
\value{
A patchwork/ggplot object combining the stratigraphic plot
and sample labels. This object can be further modified with
\code{\link[ggplot2:theme]{ggplot2::theme()}} or additional patchwork operators.
}
\description{
Combines a grainsize–depth plot and sample label plot into a single
composite figure using the \link[patchwork:patchwork-package]{patchwork::patchwork} framework. The two plots are aligned
and legends are collected at the bottom.
}
\examples{
example_data_strat |>
  ggstrat_samples(section_name = "21LSHD02")
}
