% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_and_apply_delay.R
\name{estimate_and_apply_delay}
\alias{estimate_and_apply_delay}
\title{Estimate and apply delay from a reporting triangle}
\usage{
estimate_and_apply_delay(
  reporting_triangle,
  n = nrow(reporting_triangle),
  delay_pmf = NULL,
  validate = TRUE
)
}
\arguments{
\item{reporting_triangle}{A \link{reporting_triangle} object with rows
representing reference times and columns representing delays.
Can be a reporting matrix or incomplete reporting matrix.
Can also be a ragged reporting triangle, where multiple columns are
reported for the same row (e.g., weekly reporting of daily data).}

\item{n}{Integer indicating the number of reference times (observations) to
be used in the estimate of the reporting delay, always starting from the
most recent reporting delay. The default is to use the whole reporting
triangle, so \code{nrow(reporting_triangle)}.}

\item{delay_pmf}{Vector of delays assumed to be indexed
starting at the first delay column in \code{reporting_triangle}.
Default is \code{NULL}, which will estimate a delay from the
\code{reporting_triangle}.}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}
}
\value{
\code{pt_nowcast_matrix} A \code{reporting_triangle} object of point nowcasts
with the same structure as the input
}
\description{
This function generates a point nowcast by estimating a delay distribution
from the reporting triangle and applying it to complete the triangle. If a
delay distribution is specified, this will be used to generate the
nowcast, otherwise, a delay distribution will be estimated from the
\code{reporting_triangle}.
}
\examples{
# Estimate and apply delay using default parameters
pt_nowcast_matrix <- estimate_and_apply_delay(
  reporting_triangle = example_reporting_triangle
)
pt_nowcast_matrix

# Use downward correction example with specific rows for delay estimation
pt_nowcast_matrix <- estimate_and_apply_delay(
  reporting_triangle = example_downward_corr_rt,
  n = 5
)
pt_nowcast_matrix

# Provide a pre-computed delay PMF
delay_pmf <- estimate_delay(
  reporting_triangle = example_reporting_triangle
)
pt_nowcast_matrix <- estimate_and_apply_delay(
  reporting_triangle = example_reporting_triangle,
  delay_pmf = delay_pmf
)
pt_nowcast_matrix
}
\seealso{
High-level workflow wrapper functions
\code{\link{allocate_reference_times}()},
\code{\link{estimate_and_apply_delays}()},
\code{\link{estimate_and_apply_uncertainty}()},
\code{\link{estimate_uncertainty_retro}()}
}
\concept{workflow_wrappers}
