% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_uncertainty.R
\name{estimate_uncertainty}
\alias{estimate_uncertainty}
\title{Estimate uncertainty parameters}
\usage{
estimate_uncertainty(
  point_nowcast_matrices,
  truncated_reporting_triangles,
  retro_reporting_triangles,
  n = length(point_nowcast_matrices),
  uncertainty_model = fit_by_horizon,
  ref_time_aggregator = identity,
  delay_aggregator = function(x) rowSums(x, na.rm = TRUE),
  validate = TRUE
)
}
\arguments{
\item{point_nowcast_matrices}{List of point nowcast matrices where rows
represent reference time points and columns represent delays.}

\item{truncated_reporting_triangles}{List of truncated reporting matrices,
containing all observations as of the latest reference time. Elements of
list are paired with elements of \code{point_nowcast_matrices}.}

\item{retro_reporting_triangles}{List of \code{n} truncated reporting triangle
matrices with as many rows as available given the truncation.}

\item{n}{Integer indicating the number of reporting matrices to use to
estimate the uncertainty parameters.}

\item{uncertainty_model}{Function that ingests a matrix of observations and a
matrix of predictions and returns a vector that can be used to
apply uncertainty using the same error model. Default is
\code{fit_by_horizon} with arguments of \code{obs} matrix of observations and
\code{pred} the matrix of predictions that fits each column (horizon)
to a negative binomial observation model by default. The user can
specify a different fitting model by replacing the
\code{fit_model} argument in \code{fit_by_horizon}.}

\item{ref_time_aggregator}{Function that operates along the rows (reference
times) of the retrospective point nowcast matrix before it has been
aggregated across columns (delays). Default is \code{identity}
which does not aggregate across reference times.}

\item{delay_aggregator}{Function that operates along the columns (delays)
of the retrospective point nowcast matrix after it has been aggregated
across reference times. Default is \code{function(x) rowSums(x, na.rm = TRUE)}.}

\item{validate}{Logical. If TRUE (default), validates the object. Set to
FALSE only when called from functions that already validated.}
}
\value{
\code{uncertainty_params} Vector of length of the number of horizons,
with each element representing the estimate of the uncertainty parameter
for each horizon. The specific parameter type depends on the chosen error
model.
}
\description{
This function ingests a list of point nowcast matrices and a corresponding
list of truncated reporting matrices and uses both to estimate a
vector of uncertainty parameters from the observations
and estimates at each horizon, starting at 0 up until the max delay
number of horizons.
}
\examples{
# Use example data to create reporting triangle
data_as_of_df <- syn_nssp_df[syn_nssp_df$report_date <= "2026-04-01", ]
rep_tri <- as_reporting_triangle(data = data_as_of_df)

# Create retrospective nowcasts
trunc_rts <- truncate_to_rows(rep_tri, n = 2)
retro_rts <- apply_reporting_structures(trunc_rts)
retro_nowcasts <- estimate_and_apply_delays(retro_rts)

# Estimate dispersion parameters using default negative binomial model
disp_params <- estimate_uncertainty(
  point_nowcast_matrices = retro_nowcasts,
  truncated_reporting_triangles = trunc_rts,
  retro_reporting_triangles = retro_rts
)
disp_params

# Estimate dispersion parameters from rolling sum on the reference times
if (requireNamespace("zoo", quietly = TRUE)) {
  disp_params_agg <- estimate_uncertainty(
    point_nowcast_matrices = retro_nowcasts,
    truncated_reporting_triangles = trunc_rts,
    retro_reporting_triangles = retro_rts,
    ref_time_aggregator = function(x) zoo::rollsum(x, k = 2, align = "right")
  )
  disp_params_agg
}
}
\seealso{
Observation error estimation functions
\code{\link{fit_by_horizon}()},
\code{\link{fit_nb}()}
}
\concept{estimate_observation_error}
