% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes_factor_comparison.R
\name{bayes_factor_comparison}
\alias{bayes_factor_comparison}
\title{Bayesian Factor Comparison Between Models}
\usage{
bayes_factor_comparison(
  ...,
  method = "bridge_sampling",
  repetitions = 5,
  silent = TRUE
)
}
\arguments{
\item{...}{Named or unnamed brmsfit objects to compare}

\item{method}{Character. Method for computing marginal likelihood.
Options: "bridge_sampling" (default), "waic"}

\item{repetitions}{Integer. Number of bridge sampling repetitions (default: 5)}

\item{silent}{Logical. Suppress messages? (default: TRUE)}
}
\value{
A list of class \code{bayes_factor_comparison} containing:
\item{bayes_factor}{Bayes Factor for 2-model comparison}
\item{log_bf}{Log Bayes Factor}
\item{interpretation}{Interpretation of BF strength}
\item{marginal_likelihoods}{Data frame with model-level MLs}
\item{model_names}{Character vector of model names}
\item{pairwise_comparisons}{Data frame of pairwise BFs if 3+ models}
}
\description{
Computes and compares Bayes Factors between two or more Bayesian models
using both marginal likelihood approximation and bridge sampling methods.
}
