% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IC.R
\name{IC}
\alias{IC}
\alias{DIC}
\alias{AIC}
\alias{BIC}
\alias{WAIC}
\alias{BIC.lm_b}
\alias{BIC.glm_b}
\alias{BIC.aov_b}
\alias{AIC.lm_b}
\alias{AIC.glm_b}
\alias{AIC.aov_b}
\alias{DIC.lm_b}
\alias{DIC.glm_b}
\alias{DIC.aov_b}
\alias{WAIC.lm_b}
\alias{WAIC.aov_b}
\alias{WAIC.glm_b}
\title{Compute AIC, BIC, DIC, or WAIC for aov_b or lm_b objects.  (Lower is better.)}
\usage{
DIC(object, ...)

\method{BIC}{lm_b}(object, ...)

\method{BIC}{glm_b}(object, ...)

\method{BIC}{aov_b}(object, ...)

\method{AIC}{lm_b}(object, ...)

\method{AIC}{glm_b}(object, ...)

\method{AIC}{aov_b}(object, ...)

\method{DIC}{lm_b}(object, seed = 1, mc_error = 0.01, ...)

\method{DIC}{glm_b}(object, seed = 1, ...)

\method{DIC}{aov_b}(object, ...)

\method{WAIC}{lm_b}(object, seed = 1, ...)

\method{WAIC}{aov_b}(object, ...)

\method{WAIC}{glm_b}(object, seed = 1, ...)
}
\arguments{
\item{object}{aov_b, lm_b, or glm_b object}

\item{...}{Passed to methods.}

\item{seed}{integer.  Always set your seed!!!}

\item{mc_error}{The number of posterior draws will ensure that
with 99\% probability the posterior mean of the deviance for DIC will be
within \eqn{\pm}\code{mc_error}E(deviance).}
}
\value{
Numeric (or in the case of DIC, a numeric vector)
}
\description{
Compute AIC, BIC, DIC, or WAIC for aov_b or lm_b objects.  (Lower is better.)
}
\examples{
\donttest{
set.seed(2025)
N = 500
test_data <-
  data.frame(x1 = rnorm(N),
             x2 = rnorm(N),
             x3 = letters[1:5])
test_data$outcome <-
  rnorm(N,-1 + test_data$x1 + 2 * (test_data$x3 \%in\% c("d","e")) )
fit1 <-
  lm_b(outcome ~ x1 + x2 + x3,
       data = test_data)
AIC(fit1)
BIC(fit1)
DIC(fit1)
WAIC(fit1)
}


}
