% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicators.R
\name{hpie}
\alias{hpie}
\title{Hurlbert's Probability of Interspecific Encounter (PIE)}
\usage{
hpie(taxon, count)
}
\arguments{
\item{taxon}{character vector containing taxa}

\item{count}{numeric vector containing counts}
}
\value{
A numeric vector with the probability of interspecific encounter
     (PIE).
}
\description{
The probability that two individuals selected at random (\emph{without}
replacement) from a sample will belong to different species is given by
(Hurlbert, 1971, p.579, Eq. 3):
\deqn{\Delta_1 = \sum_{i=1}^S (\frac{N_i}{N})(\frac{N-N_i}{N-1}) =
(\frac{N}{N-1})\Delta_2}{\Delta1 = \sum_{i=1}^S (N[i]/N)((N-N[i])(N-1)) =
(N/(N-1))\Delta2}
where \eqn{\Delta_2}{\Delta2} (Hurlbert, 1971, p.579, Eq. 4) is the
probability that two individuals selected at random (\emph{with}
replacement) from a sample will belong to different species:
\deqn{\Delta_2 = 1-\sum_{i=1}^S \pi_i^2}{\Delta2 = 1-\sum_{i=1}^S \pi[i]^2}
where  \eqn{N_i}{N[i]} is the number of individuals of the \emph{i}th
species in the community, \eqn{N} is the total number of individuals in the
community, \eqn{\pi_i = N_i/N}{\pi[i] = N[i]/N}, and \eqn{S} is the number of
species in the community.
Note that Hurlbert's PIE \code{hpie} is the complement of
\code{\link{simpson}}.
}
\examples{
     hpie(
         taxon = c("Euspira pulchella", "Nephtys cirrosa"),
         count = c(6, 12)
     )

}
\references{
Hurlbert, S.H., 1971. The Nonconcept of Species Diversity:
     A Critique and Alternative Parameters. Ecology 52:577-586.
}
\seealso{
\code{\link{simpson}}, \code{\link{hurlbert}}
}
