# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title C++ log-likelihood for fixed-dispersion beta interval regression
#'   with mixed censoring
#' @description Computes the total log-likelihood for a beta regression model
#'   with interval-censored responses and a single (scalar) dispersion
#'   parameter, supporting all four censoring types.
#' @param param  Numeric vector: first \code{ncol(X)} elements are beta
#'   coefficients, the last element is the scalar dispersion parameter.
#' @param X      Design matrix (n x p).
#' @param y_left  Numeric vector of left interval endpoints on (0, 1).
#' @param y_right Numeric vector of right interval endpoints on (0, 1).
#' @param yt     Numeric vector of midpoint response on (0, 1).
#' @param delta  Integer vector of censoring indicators (0,1,2,3).
#' @param link_mu_code  Integer code for the mean link function.
#' @param link_phi_code Integer code for the dispersion link function.
#' @param repar  Integer reparameterization type (0, 1, or 2).
#' @return Scalar log-likelihood value.
#' @keywords internal
.brs_loglik_fixed_cpp <- function(param, X, y_left, y_right, yt, delta, link_mu_code, link_phi_code, repar) {
    .Call(`_betaregscale_betaregscale_loglik_fixed_cpp`, param, X, y_left, y_right, yt, delta, link_mu_code, link_phi_code, repar)
}

#' @title C++ log-likelihood for variable-dispersion beta interval regression
#'   with mixed censoring
#' @description Computes the total log-likelihood for a beta regression model
#'   with interval-censored responses and observation-specific dispersion,
#'   supporting all four censoring types.
#' @param param Numeric vector: first \code{ncol(X)} elements are beta
#'   coefficients, next \code{ncol(Z)} elements are gamma (phi) coefficients.
#' @param X      Design matrix for the mean submodel (n x p).
#' @param Z      Design matrix for the dispersion submodel (n x q).
#' @param y_left  Numeric vector of left interval endpoints on (0, 1).
#' @param y_right Numeric vector of right interval endpoints on (0, 1).
#' @param yt     Numeric vector of midpoint response on (0, 1).
#' @param delta  Integer vector of censoring indicators (0,1,2,3).
#' @param link_mu_code  Integer code for the mean link function.
#' @param link_phi_code Integer code for the dispersion link function.
#' @param repar  Integer reparameterization type (0, 1, or 2).
#' @return Scalar log-likelihood value.
#' @keywords internal
.brs_loglik_variable_cpp <- function(param, X, Z, y_left, y_right, yt, delta, link_mu_code, link_phi_code, repar) {
    .Call(`_betaregscale_betaregscale_loglik_variable_cpp`, param, X, Z, y_left, y_right, yt, delta, link_mu_code, link_phi_code, repar)
}

#' @title C++ gradient for fixed-dispersion log-likelihood
#' @description Returns the gradient vector of the log-likelihood with
#'   respect to all parameters (beta coefficients + scalar phi), using
#'   a central-difference numerical approximation (step = 1e-6).
#' @param param  Parameter vector (same layout as loglik function).
#' @param X      Design matrix (n x p).
#' @param y_left  Left endpoints.
#' @param y_right Right endpoints.
#' @param yt     Midpoint responses.
#' @param delta  Integer censoring indicators.
#' @param link_mu_code  Integer mean link code.
#' @param link_phi_code Integer dispersion link code.
#' @param repar  Integer reparameterization type.
#' @return Numeric gradient vector of length \code{ncol(X) + 1}.
#' @keywords internal
.brs_grad_fixed_cpp <- function(param, X, y_left, y_right, yt, delta, link_mu_code, link_phi_code, repar) {
    .Call(`_betaregscale_betaregscale_grad_fixed_cpp`, param, X, y_left, y_right, yt, delta, link_mu_code, link_phi_code, repar)
}

#' @title C++ gradient for variable-dispersion log-likelihood
#' @description Central-difference gradient for the variable-dispersion model.
#' @param param  Parameter vector.
#' @param X      Mean design matrix.
#' @param Z      Dispersion design matrix.
#' @param y_left  Left endpoints.
#' @param y_right Right endpoints.
#' @param yt     Midpoint responses.
#' @param delta  Integer censoring indicators.
#' @param link_mu_code  Integer mean link code.
#' @param link_phi_code Integer dispersion link code.
#' @param repar  Integer reparameterization type.
#' @return Numeric gradient vector.
#' @keywords internal
.brs_grad_variable_cpp <- function(param, X, Z, y_left, y_right, yt, delta, link_mu_code, link_phi_code, repar) {
    .Call(`_betaregscale_betaregscale_grad_variable_cpp`, param, X, Z, y_left, y_right, yt, delta, link_mu_code, link_phi_code, repar)
}

#' @title C++ log-likelihood for mixed beta interval regression (Laplace)
#' @description Computes the marginal log-likelihood for a random-intercept
#'   beta interval model using a Laplace approximation of group-specific
#'   integrals over Gaussian random effects.
#' @param param Parameter vector:
#'   \code{beta (p), gamma (q), log_sigma_b (1)}.
#' @param X Mean-model design matrix.
#' @param Z Precision-model design matrix.
#' @param y_left Left interval endpoints.
#' @param y_right Right interval endpoints.
#' @param yt Midpoint responses.
#' @param delta Censoring indicator vector.
#' @param group Integer group index (1..G), one per observation.
#' @param link_mu_code Integer code for mean link.
#' @param link_phi_code Integer code for precision link.
#' @param repar Integer beta reparameterization code.
#' @return Scalar marginal log-likelihood.
#' @keywords internal
.brsmm_loglik_laplace_cpp <- function(param, X, Z, y_left, y_right, yt, delta, group, link_mu_code, link_phi_code, repar) {
    .Call(`_betaregscale_betaregscale_loglik_mixed_laplace_cpp`, param, X, Z, y_left, y_right, yt, delta, group, link_mu_code, link_phi_code, repar)
}

#' @title Group-level modes for random intercept (Laplace)
#' @description Computes the posterior mode and local SD for each group random
#'   intercept under the current parameter vector.
#' @param param Parameter vector:
#'   \code{beta (p), gamma (q), log_sigma_b (1)}.
#' @param X Mean-model design matrix.
#' @param Z Precision-model design matrix.
#' @param y_left Left interval endpoints.
#' @param y_right Right interval endpoints.
#' @param yt Midpoint responses.
#' @param delta Censoring indicator vector.
#' @param group Integer group index (1..G), one per observation.
#' @param link_mu_code Integer code for mean link.
#' @param link_phi_code Integer code for precision link.
#' @param repar Integer beta reparameterization code.
#' @return Numeric matrix with columns \code{mode_b} and \code{sd_b}.
#' @keywords internal
.brsmm_group_modes_cpp <- function(param, X, Z, y_left, y_right, yt, delta, group, link_mu_code, link_phi_code, repar) {
    .Call(`_betaregscale_betaregscale_group_modes_cpp`, param, X, Z, y_left, y_right, yt, delta, group, link_mu_code, link_phi_code, repar)
}

#' @title Mixed Model Log-Likelihood (Eigen)
#' @description Computes marginal log-likelihood using Laplace, AGHQ, or QMC.
#' @param param [beta, gamma, theta_re]
#' @param X Mean design matrix
#' @param Z Precision design matrix
#' @param Xr Random-effects design matrix
#' @param y_left,y_right,yt,delta,group Data
#' @param method 0=Laplace, 1=AGHQ, 2=QMC
#' @param n_points Number of quadrature/QMC points
#' @keywords internal
brsmm_loglik_eigen <- function(param, X, Z, Xr, y_left, y_right, yt, delta, group, link_mu, link_phi, repar, method, n_points) {
    .Call(`_betaregscale_brsmm_loglik_eigen`, param, X, Z, Xr, y_left, y_right, yt, delta, group, link_mu, link_phi, repar, method, n_points)
}

#' @title Group modes for mixed model (Eigen backend)
#' @keywords internal
brsmm_group_modes_eigen <- function(param, X, Z, Xr, y_left, y_right, yt, delta, group, link_mu, link_phi, repar) {
    .Call(`_betaregscale_brsmm_group_modes_eigen`, param, X, Z, Xr, y_left, y_right, yt, delta, group, link_mu, link_phi, repar)
}

