% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.R
\name{autoplot.brs}
\alias{autoplot.brs}
\title{ggplot2 autoplot for brs models}
\usage{
\method{autoplot}{brs}(
  object,
  type = c("calibration", "score_dist", "cdf", "residuals_by_delta"),
  bins = 10L,
  scores = NULL,
  newdata = NULL,
  n_grid = 200L,
  max_curves = 6L,
  residual_type = "rqr",
  ...
)
}
\arguments{
\item{object}{A fitted \code{"brs"} object.}

\item{type}{Plot type:
\code{"calibration"}, \code{"score_dist"}, \code{"cdf"}, or
\code{"residuals_by_delta"}.}

\item{bins}{Number of bins used in calibration plots.}

\item{scores}{Optional integer vector of scores for \code{"score_dist"}.
Defaults to all scores from \code{0} to \code{ncuts}.}

\item{newdata}{Optional data frame of covariate scenarios used by
\code{type = "cdf"}.}

\item{n_grid}{Number of points on \eqn{(0,1)} used to draw CDF curves.}

\item{max_curves}{Maximum number of CDF curves shown when \code{newdata}
is not provided.}

\item{residual_type}{Residual type passed to \code{\link{residuals.brs}}
for \code{type = "residuals_by_delta"}.}

\item{...}{Currently ignored.}
}
\value{
A \code{ggplot2} object.
}
\description{
Produces ggplot2 diagnostics tailored to interval-censored scale models.
}
\details{
\code{type = "calibration"} bins predictions and compares mean observed vs
mean predicted response in each bin.

\code{type = "score_dist"} compares observed score frequencies against
expected frequencies implied by the fitted beta interval model.
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  x2 = rep(c(0, 0, 1, 1), 5)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1 + x2, data = prep)
ggplot2::autoplot(fit, type = "calibration")
ggplot2::autoplot(fit, type = "score_dist")
}

}
\references{
Lopes, J. E. (2023). \emph{Modelos de regressao beta para dados de escala}.
Master's dissertation, Universidade Federal do Parana, Curitiba.
URI: \url{https://hdl.handle.net/1884/86624}.

Hawker, G. A., Mian, S., Kendzerska, T., and French, M. (2011).
Measures of adult pain: Visual Analog Scale for Pain (VAS Pain),
Numeric Rating Scale for Pain (NRS Pain), McGill Pain Questionnaire (MPQ),
Short-Form McGill Pain Questionnaire (SF-MPQ), Chronic Pain Grade Scale
(CPGS), Short Form-36 Bodily Pain Scale (SF-36 BPS), and Measure of
Intermittent and Constant Osteoarthritis Pain (ICOAP).
Arthritis Care and Research, 63(S11), S240-S252.
\doi{10.1002/acr.20543}

Hjermstad, M. J., Fayers, P. M., Haugen, D. F., et al. (2011).
Studies comparing Numerical Rating Scales, Verbal Rating Scales, and
Visual Analogue Scales for assessment of pain intensity in adults:
a systematic literature review.
Journal of Pain and Symptom Management, 41(6), 1073-1093.
\doi{10.1016/j.jpainsymman.2010.08.016}
}
\seealso{
\code{\link{brs}}, \code{\link{plot.brs}},
  \code{\link{autoplot.brs_bootstrap}}
}
