% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{fitted.brs}
\alias{fitted.brs}
\title{Extract fitted values}
\usage{
\method{fitted}{brs}(object, type = c("mu", "phi"), ...)
}
\arguments{
\item{object}{A fitted \code{"betaregscale"} object.}

\item{type}{Character: \code{"mu"} (default) or \code{"phi"}.}

\item{...}{Currently ignored.}
}
\value{
Numeric vector of fitted values.
}
\description{
Extract fitted values
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10)
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brs(y ~ x1, data = prep)
head(fitted(fit))
head(fitted(fit, type = "phi"))
}

}
\seealso{
\code{\link{brs}}, \code{\link{residuals.brs}},
  \code{\link{predict.brs}}
}
