% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brsmm-methods.R
\name{logLik.brsmm}
\alias{logLik.brsmm}
\title{Log-likelihood for brsmm models}
\usage{
\method{logLik}{brsmm}(object, ...)
}
\arguments{
\item{object}{A fitted \code{"brsmm"} object.}

\item{...}{Currently ignored.}
}
\value{
Object of class \code{"logLik"}.
}
\description{
Log-likelihood for brsmm models
}
\examples{
\donttest{
dat <- data.frame(
  y = c(
    0, 5, 20, 50, 75, 90, 100, 30, 60, 45,
    10, 40, 55, 70, 85, 25, 35, 65, 80, 15
  ),
  x1 = rep(c(1, 2), 10),
  id = factor(rep(1:4, each = 5))
)
prep <- brs_prep(dat, ncuts = 100)
fit <- brsmm(y ~ x1, random = ~ 1 | id, data = prep)
logLik(fit)
}

}
\seealso{
\code{\link{brsmm}}, \code{\link{AIC.brsmm}},
  \code{\link{BIC.brsmm}}, \code{\link{brs_gof}}
}
