% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhetGP-package.R
\docType{package}
\name{bhetGP-package}
\alias{bhetGP-package}
\title{Package bhetGP}
\description{
Performs Bayesian posterior inference for heteroskedastic Gaussian processes.
Models are trained through MCMC including elliptical slice sampling (ESS) of 
latent noise processes and Metropolis-Hastings sampling of 
kernel hyperparameters. Replicates are handled efficientyly through a
Woodbury formulation of the joint likelihood for the mean and noise process 
(Binois, M., Gramacy, R., Ludkovski, M. (2018) <doi:10.1080/10618600.2018.1458625>)
For large data, Vecchia-approximation for faster 
computation is leveraged (Sauer, A., Cooper, A., and Gramacy, R.,
(2023), <doi:10.1080/10618600.2022.2129662>). Incorporates 'OpenMP' and 
SNOW parallelization and utilizes 'C'/'C++' under the hood.
}
\section{Important Functions}{

\itemize{
  \item \code{\link[bhetGP]{bhetGP}}: conducts MCMC sampling of 
  hyperparameters and latent noise layer for a heteroskedatic GP.
  \item \code{\link[bhetGP]{bhomGP}}: conducts MCMC sampling of 
  hyperparameters for a homoskedastic GP.
  \item \code{\link[bhetGP]{trim}}: cuts off burn-in and optionally thins 
  samples
  \item \code{\link[bhetGP]{predict}}: calculates posterior mean and 
  variance over a set of input locations (optionally calculates EI or entropy)
  \item \code{\link[bhetGP]{plot}}: produces trace plots, hidden layer 
  plots, and posterior predictive plots
}
}

\examples{
# See ?bhetGP, or ?bhomGP for examples

}
\references{
M. Binois, Robert B. Gramacy, M. Ludkovski (2018), Practical heteroskedastic 
Gaussian process modeling for large simulation experiments,
Journal of Computational and Graphical Statistics, 27(4), 808--821.

Katzfuss, Matthias, Joseph Guinness, and Earl Lawrence. 
Scaled Vecchia approximation for fast computer-model emulation. 
SIAM/ASA Journal on Uncertainty Quantification 10.2 (2022): 537-554.

Sauer, A., Cooper, A., & Gramacy, R. B. (2023). Vecchia-approximated deep Gaussian 
processes for computer experiments. 
Journal of Computational and Graphical Statistics, 32(3), 824-837.
}
\author{
Parul V. Patil \email{parulvijay@vt.edu}
}
