% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/telemetry_ingest.R
\name{read_otel_sqlite}
\alias{read_otel_sqlite}
\title{Read OpenTelemetry SQLite database}
\usage{
read_otel_sqlite(source)
}
\arguments{
\item{source}{SQLite database path or DBI connection object}
}
\value{
Data frame with bidux event schema (converted from spans)
}
\description{
Reads OpenTelemetry span data from SQLite databases that store OTEL traces.
Looks for standard OTEL table names (spans, span_events, span_attributes) and
joins them to reconstruct the span structure before converting to bidux events.
}
\examples{
\dontrun{
events <- read_otel_sqlite("otel_traces.db")
names(events)
# [1] "timestamp" "session_id" "event_type" "input_id" "value" "error_message"
# [7] "output_id" "navigation_id"
}
}
\keyword{internal}
