% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputer_mean_mode_median.R
\name{impute_with_MeMoMe}
\alias{impute_with_MeMoMe}
\title{Mean/Mode/Median Imputation function}
\usage{
impute_with_MeMoMe(sc, sdf, column = NULL, impute_mode, printFlags = TRUE)
}
\arguments{
\item{sc}{A Spark connection}

\item{sdf}{A Spark DataFrame}

\item{column}{The column(s) to impute. If NULL, all columns will be imputed}

\item{impute_mode}{Which imputation method to use for each column. Options are "mean", "mode", "median", or "none"}

\item{printFlags}{Wether or not to print the imputation process to the console. Default is TRUE.}
}
\value{
The Spark DataFrame with missing values imputed
}
\description{
This function imputes missing values in a Spark DataFrame using the mean, mode, or median of the observed values.
}
\examples{
# This example is not executed since it needs additional software (Apache Spark)
\dontrun{
# Create a dataset with various types of missing values
library(sparklyr)
library(dplyr)

# Connect to Spark
# Assumes that you have already installed Spark with sparklyr::spark_install()
sc <- spark_connect(master = "local")

# Create sample data with missing values in different columns
sample_data <- data.frame(
  age = c(25, NA, 35, 28, NA, 45),
  salary = c(50000, 60000, NA, 55000, 80000, NA),
  department = c("Sales", NA, "IT", "Sales", "HR", "IT"),
  rating = c(4.2, 3.8, NA, 4.5, 3.9, NA)
)

# Copy to Spark DataFrame
sdf <- copy_to(sc, sample_data, "sample_data")

# Impute different columns using different methods
imputed_sdf <- impute_with_MeMoMe(
  sc = sc,
  sdf = sdf,
  column = c("age", "salary", "department", "rating"),
  impute_mode = c("median", "mean", "mode", "mean"),
  printFlags = TRUE
)

# View results
imputed_sdf \%>\% collect()

# Example 2: Impute only specific columns
partial_imputed_sdf <- impute_with_MeMoMe(
  sc = sc,
  sdf = sdf,
  column = c("age", "salary"),
  impute_mode = c("mean", "median"),
  printFlags = FALSE
)

# Clean up
spark_disconnect(sc)
}
}
