% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_series_blocks.R
\name{.stationary_bootstrap}
\alias{.stationary_bootstrap}
\title{Stationary bootstrap indices}
\usage{
.stationary_bootstrap(idx, mean_block)
}
\arguments{
\item{idx}{Integer vector of ordered indices.}

\item{mean_block}{Positive numeric, expected block length.}
}
\value{
Integer vector of permuted indices of the same length as `idx`.
}
\description{
Implements the stationary bootstrap of Politis & Romano (1994),
which resamples contiguous blocks of variable length to preserve
weak temporal dependence while maintaining ergodicity.
}
\references{
Politis, D. N., & Romano, J. P. (1994).
*The stationary bootstrap.* Journal of the American Statistical Association, 89(428), 1303-1313.
}
\keyword{internal}
