% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/08-compare.R
\name{br_compare_models}
\alias{br_compare_models}
\title{Compare univariate and multivariate models}
\usage{
br_compare_models(
  data,
  y,
  x,
  x2 = NULL,
  method,
  ...,
  n_workers = 1L,
  model_args = list(),
  run_args = list()
)
}
\arguments{
\item{data}{A \code{data.frame} containing all necessary variables for analysis.}

\item{y}{Character vector specifying dependent variables (response variables).
For GLM models, this is typically a single character (e.g., \code{"outcome"}).
For Cox-PH models, it should be a length-2 vector in the format \code{c("time", "status")}.}

\item{x}{Character vector specifying focal independent terms (predictors).
These will be modeled both individually (univariate) and together (multivariate).}

\item{x2}{Character vector specifying control independent terms (predictors, optional).
These are included in all models (both univariate and multivariate).}

\item{method}{Method for model construction. See \code{\link[=br_set_model]{br_set_model()}} for details.}

\item{...}{Additional arguments passed to \code{\link[=br_run]{br_run()}}.}

\item{n_workers}{Integer, indicating number of workers for parallel processing.}

\item{model_args}{A list of arguments passed to \code{br_set_model()}.}

\item{run_args}{A list of arguments passed to \code{br_run()}.}
}
\value{
A list with class \code{breg_comparison} containing:
\itemize{
\item \code{univariate}: breg object with univariate model results
\item \code{multivariate}: breg object with multivariate model results
\item \code{combined_results}: Combined results data frame with a \code{mode} column
\item \code{combined_results_tidy}: Combined tidy results with a \code{mode} column
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function builds both univariate models (each predictor separately) and
a multivariate model (all predictors together), then combines the results
for comparison. This is useful for understanding how predictor effects change
when accounting for other variables.
}
\examples{
# Compare univariate vs multivariate for Cox models
lung <- survival::lung |>
  dplyr::filter(ph.ecog != 3)
lung$ph.ecog <- factor(lung$ph.ecog)

comparison <- br_compare_models(
  lung,
  y = c("time", "status"),
  x = c("ph.ecog", "ph.karno", "pat.karno"),
  x2 = c("age", "sex"),
  method = "coxph"
)

# View combined results
comparison$combined_results_tidy

# Create forest plot comparison
br_show_forest_comparison(comparison)
}
\seealso{
Other br_compare: 
\code{\link{br_show_forest_comparison}()}
}
\concept{br_compare}
