% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql-query-execution.R
\name{db_sql_query}
\alias{db_sql_query}
\title{Execute query with SQL Warehouse}
\usage{
db_sql_query(
  warehouse_id,
  statement,
  schema = NULL,
  catalog = NULL,
  parameters = NULL,
  row_limit = NULL,
  byte_limit = NULL,
  wait_timeout = "5s",
  return_arrow = FALSE,
  max_active_connections = 30,
  fetch_timeout = 300,
  disposition = "EXTERNAL_LINKS",
  host = db_host(),
  token = db_token(),
  show_progress = TRUE
)
}
\arguments{
\item{warehouse_id}{String, ID of warehouse upon which to execute a statement.}

\item{statement}{String, the SQL statement to execute. The statement can
optionally be parameterized, see \code{parameters}.}

\item{schema}{String, sets default schema for statement execution, similar
to \verb{USE SCHEMA} in SQL.}

\item{catalog}{String, sets default catalog for statement execution, similar
to \verb{USE CATALOG} in SQL.}

\item{parameters}{List of Named Lists, parameters to pass into a SQL
statement containing parameter markers.

A parameter consists of a name, a value, and \emph{optionally} a type.
To represent a \code{NULL} value, the value field may be omitted or set to \code{NULL}
explicitly.

See \href{https://docs.databricks.com/api/workspace/statementexecution/executestatement}{docs}
for more details.}

\item{row_limit}{Integer, applies the given row limit to the statement's
result set, but unlike the \code{LIMIT} clause in SQL, it also sets the
\code{truncated} field in the response to indicate whether the result was trimmed
due to the limit or not.}

\item{byte_limit}{Integer, applies the given byte limit to the statement's
result size. Byte counts are based on internal data representations and
might not match the final size in the requested format. If the result was
truncated due to the byte limit, then \code{truncated} in the response is set to
true. When using \code{EXTERNAL_LINKS} disposition, a default byte_limit of
100 GiB is applied if \code{byte_limit} is not explicitly set.}

\item{wait_timeout}{String, default is \code{"10s"}. The time in seconds the call
will wait for the statement's result set as \code{Ns}, where \code{N} can be set to
\code{0} or to a value between \code{5} and \code{50}.
When set to \verb{0s}, the statement will execute in asynchronous mode and the
call will not wait for the execution to finish. In this case, the call
returns directly with \code{PENDING} state and a statement ID which can be used
for polling with \code{\link[=db_sql_exec_status]{db_sql_exec_status()}}.

When set between \code{5} and \code{50} seconds, the call will behave synchronously up
to this timeout and wait for the statement execution to finish. If the
execution finishes within this time, the call returns immediately with a
manifest and result data (or a \code{FAILED} state in case of an execution error).

If the statement takes longer to execute, \code{on_wait_timeout} determines what
should happen after the timeout is reached.}

\item{return_arrow}{Boolean, determine if result is \link[tibble:tibble]{tibble::tibble} or
\link[arrow:Table-class]{arrow::Table}.}

\item{max_active_connections}{Integer to decide on concurrent downloads.}

\item{fetch_timeout}{Integer, timeout in seconds for downloading each result chunk}

\item{disposition}{Disposition mode ("INLINE" or "EXTERNAL_LINKS")}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{show_progress}{If \code{TRUE}, show progress updates during query execution (default: \code{TRUE})}
}
\value{
\link[tibble:tibble]{tibble::tibble} or \link[arrow:Table-class]{arrow::Table}.
}
\description{
Execute query with SQL Warehouse
}
