% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/navs-legacy.R, R/navs.R
\name{navset}
\alias{navset}
\alias{navset_tab}
\alias{navset_pill}
\alias{navset_underline}
\alias{navset_pill_list}
\alias{navset_hidden}
\alias{navset_bar}
\alias{navset_card_tab}
\alias{navset_card_pill}
\alias{navset_card_underline}
\title{Navigation containers}
\usage{
navset_tab(..., id = NULL, selected = NULL, header = NULL, footer = NULL)

navset_pill(..., id = NULL, selected = NULL, header = NULL, footer = NULL)

navset_underline(..., id = NULL, selected = NULL, header = NULL, footer = NULL)

navset_pill_list(
  ...,
  id = NULL,
  selected = NULL,
  header = NULL,
  footer = NULL,
  well = TRUE,
  fluid = TRUE,
  widths = c(4, 8)
)

navset_hidden(..., id = NULL, selected = NULL, header = NULL, footer = NULL)

navset_bar(
  ...,
  title = NULL,
  id = NULL,
  selected = NULL,
  sidebar = NULL,
  fillable = TRUE,
  gap = NULL,
  padding = NULL,
  header = NULL,
  footer = NULL,
  fluid = TRUE,
  navbar_options = NULL,
  position = deprecated(),
  bg = deprecated(),
  inverse = deprecated(),
  collapsible = deprecated()
)

navset_card_tab(
  ...,
  id = NULL,
  selected = NULL,
  title = NULL,
  sidebar = NULL,
  header = NULL,
  footer = NULL,
  height = NULL,
  full_screen = FALSE,
  wrapper = card_body
)

navset_card_pill(
  ...,
  id = NULL,
  selected = NULL,
  title = NULL,
  sidebar = NULL,
  header = NULL,
  footer = NULL,
  height = NULL,
  placement = c("above", "below"),
  full_screen = FALSE,
  wrapper = card_body
)

navset_card_underline(
  ...,
  id = NULL,
  selected = NULL,
  title = NULL,
  sidebar = NULL,
  header = NULL,
  footer = NULL,
  height = NULL,
  full_screen = FALSE,
  wrapper = card_body
)
}
\arguments{
\item{...}{a collection of \code{\link[=nav_panel]{nav_panel()}} items.}

\item{id}{a character string used for dynamically updating the container (see
\code{\link[=nav_select]{nav_select()}}).}

\item{selected}{a character string matching the \code{value} of a particular
\code{\link[=nav_panel]{nav_panel()}} item to selected by default.}

\item{header}{UI element(s) (\link[htmltools:builder]{htmltools::tags}) to display \emph{above} the nav
content. For \code{card}-based navsets, these elements are implicitly wrapped in
a \code{card_body()}. To control things like \code{padding}, \code{fill}, etc., wrap the
elements in an explicit \code{\link[=card_body]{card_body()}}.}

\item{footer}{UI element(s) (\link[htmltools:builder]{htmltools::tags}) to display \emph{below} the nav
content. For \code{card}-based navsets, these elements are implicitly wrapped in
a \code{card_body()}. To control things like \code{padding}, \code{fill}, etc., wrap the
elements in an explicit \code{\link[=card_body]{card_body()}}.}

\item{well}{\code{TRUE} to place a well (gray rounded rectangle) around the
navigation list.}

\item{fluid}{\code{TRUE} to use fluid layout; \code{FALSE} to use fixed
layout.}

\item{widths}{Column widths of the navigation list and tabset content areas
respectively.}

\item{title}{A (left-aligned) title to place in the card header/footer. If
provided, other nav items are automatically right aligned.}

\item{sidebar}{A \code{\link[=sidebar]{sidebar()}} component to display on every \code{\link[=nav_panel]{nav_panel()}}
page.}

\item{fillable}{Whether or not to allow \code{fill} items to grow/shrink to fit
the browser window. If \code{TRUE}, all \code{\link[=nav_panel]{nav_panel()}} pages are \code{fillable}. A
character vector, matching the \code{value} of \code{\link[=nav_panel]{nav_panel()}}s to be filled, may
also be provided. Note that, if a \code{sidebar} is provided, \code{fillable} makes
the main content portion fillable.}

\item{gap}{A \link[htmltools:validateCssUnit]{CSS length unit} defining the
\code{gap} (i.e., spacing) between elements provided to \code{...}.}

\item{padding}{Padding to use for the body. This can be a numeric vector
(which will be interpreted as pixels) or a character vector with valid CSS
lengths. The length can be between one and four. If one, then that value
will be used for all four sides. If two, then the first value will be used
for the top and bottom, while the second value will be used for left and
right. If three, then the first will be used for top, the second will be
left and right, and the third will be bottom. If four, then the values will
be interpreted as top, right, bottom, and left respectively.}

\item{navbar_options}{Options to control the appearance and behavior of the
navbar. Use \code{\link[=navbar_options]{navbar_options()}} to create the list of options.}

\item{position}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=navbar_options]{navbar_options = navbar_options(position=)}} instead.}

\item{bg}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=navbar_options]{navbar_options = navbar_options(bg=)}} instead.}

\item{inverse}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=navbar_options]{navbar_options = navbar_options(inverse=)}} instead.}

\item{collapsible}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=navbar_options]{navbar_options = navbar_options(collapsible=)}} instead.}

\item{height}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{height="200px"}). Doesn't apply when a card is made \code{full_screen}
(in this case, consider setting a \code{height} in \code{\link[=card_body]{card_body()}}).}

\item{full_screen}{If \code{TRUE}, an icon will appear when hovering over the card
body. Clicking the icon expands the card to fit viewport size.}

\item{wrapper}{A function (which returns a UI element) to call on unnamed
arguments in \code{...} which are not already card item(s) (like
\code{\link[=card_header]{card_header()}}, \code{\link[=card_body]{card_body()}}, etc.). Note that non-card items are grouped
together into one \code{wrapper} call (e.g. given \code{card("a", "b", card_body("c"), "d")}, \code{wrapper} would be called twice, once with \code{"a"} and
\code{"b"} and once with \code{"d"}).}

\item{placement}{placement of the nav items relative to the content.}
}
\description{
Render a collection of \code{\link[=nav_panel]{nav_panel()}} items into a container.
}
\section{Examples}{

\subsection{A basic example}{

This first example creates a simple tabbed navigation container with two tabs.
The tab name and the content of each tab are specified in the \code{nav_panel()} calls
and \code{navset_tab()} creates the tabbed navigation around these two tabs.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(htmltools)

navset_tab(
  nav_panel(title = "One", p("First tab content.")),
  nav_panel(title = "Two", p("Second tab content."))
)
}\if{html}{\out{</div>}}

\figure{navset-tab-basic.png}{Screenshot of a basic navset_tab() example.}

In the rest of the examples, we'll include links among the tabs (or pills) in the navigation controls.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{link_shiny <- tags$a(shiny::icon("github"), "Shiny", href = "https://github.com/rstudio/shiny", target = "_blank")
link_posit <- tags$a(shiny::icon("r-project"), "Posit", href = "https://posit.co", target = "_blank")
}\if{html}{\out{</div>}}
}

\subsection{\code{navset_tab()}}{

You can fully customize the controls in the navigation component.
In this example, we've added a direct link to the Shiny repository using \code{nav_item()}.
We've also included a dropdown menu using \code{nav_menu()}
containing an option to select a third tab panel
and another direct link to Posit's website.
Finally, we've separated the primary tabs on the left
from the direct link and dropdown menu on the right
using \code{nav_spacer()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{navset_tab(
  nav_panel(title = "One", p("First tab content.")),
  nav_panel(title = "Two", p("Second tab content.")),
  nav_panel(title = "Three", p("Third tab content")),
  nav_spacer(),
  nav_menu(
    title = "Links",
    nav_item(link_shiny),
    nav_item(link_posit)
  )
)
}\if{html}{\out{</div>}}

\figure{navset-tab.png}{Screenshot of a navset_tab() example.}
}

\subsection{\code{navset_pill()}}{

\code{navset_pill()} creates a navigation container that behaves exactly like \code{navset_tab()},
but the tab toggles are \emph{pills} or button-shaped.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{navset_pill(
  nav_panel(title = "One", p("First tab content.")),
  nav_panel(title = "Two", p("Second tab content.")),
  nav_panel(title = "Three", p("Third tab content")),
  nav_spacer(),
  nav_menu(
    title = "Links",
    nav_item(link_shiny),
    nav_item(link_posit)
  )
)
}\if{html}{\out{</div>}}

\figure{navset-pill.png}{Screenshot of a navset_pill() example.}
}

\subsection{\code{navset_underline()}}{

\code{navset_underline()} creates a navigation container that behaves exactly like \code{navset_tab()} and \code{navset_pill()}, but the active/focused navigation links are styled with an underline.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{navset_underline(
  nav_panel(title = "One", p("First tab content.")),
  nav_panel(title = "Two", p("Second tab content.")),
  nav_panel(title = "Three", p("Third tab content")),
  nav_spacer(),
  nav_menu(
    title = "Links",
    nav_item(link_shiny),
    nav_item(link_posit)
  )
)
}\if{html}{\out{</div>}}

\figure{navset-underline.png}{Screenshot of a navset_underline() example.}
}

\subsection{\code{navset_card_tab()}}{

The tabbed navigation container can also be used in a \code{card()} component
thanks to \code{navset_card_tab()}.
Learn more about this approach in the
\href{https://pkgs.rstudio.com/bslib/articles/cards.html}{article about Cards},
including how to add \href{https://pkgs.rstudio.com/bslib/articles/sidebars.html#multi-page-layout}{a shared sidebar}
to all tabs in the card
using the \code{sidebar} argument of \code{navset_card_tab()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{navset_card_tab(
  nav_panel(title = "One", p("First tab content.")),
  nav_panel(title = "Two", p("Second tab content.")),
  nav_panel(title = "Three", p("Third tab content")),
  nav_spacer(),
  nav_menu(
    title = "Links",
    nav_item(link_shiny),
    nav_item(link_posit)
  )
)
}\if{html}{\out{</div>}}

\figure{navset-tab-card.png}{Screenshot of a navset_tab_card() example.}
}

\subsection{\code{navset_card_pill()}}{

Similar to \code{navset_pill()},
\code{navset_card_pill()} provides a pill-shaped variant to \code{navset_card_tab()}.
You can use the \code{placement} argument to position the navbar
\code{"above"} or \code{"below"} the card body.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{navset_card_pill(
  placement = "above",
  nav_panel(title = "One", p("First tab content.")),
  nav_panel(title = "Two", p("Second tab content.")),
  nav_panel(title = "Three", p("Third tab content")),
  nav_spacer(),
  nav_menu(
    title = "Links",
    nav_item(link_shiny),
    nav_item(link_posit)
  )
)
}\if{html}{\out{</div>}}

\figure{navset-card-pill.png}{Screenshot of a navset_card_pill() example.}
}

\subsection{\code{navset_card_underline()}}{

\code{navset_card_underline()} provides a card-based variant of \code{navset_underline()}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{navset_card_underline(
  nav_panel(title = "One", p("First tab content.")),
  nav_panel(title = "Two", p("Second tab content.")),
  nav_panel(title = "Three", p("Third tab content")),
  nav_spacer(),
  nav_menu(
    title = "Links",
    nav_item(link_shiny),
    nav_item(link_posit)
  )
)
}\if{html}{\out{</div>}}

\figure{navset-card-underline.png}{Screenshot of a navset_card_underline() example.}
}

\subsection{\code{navset_pill_list()}}{

Furthermore, \code{navset_pill_list()} creates a vertical list of navigation controls
adjacent to, rather than on top of, the tab content panels.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{navset_pill_list(
  nav_panel(title = "One", p("First tab content.")),
  nav_panel(title = "Two", p("Second tab content.")),
  nav_panel(title = "Three", p("Third tab content")),
  nav_spacer(),
  nav_menu(
    title = "Links",
    nav_item(link_shiny),
    nav_item(link_posit)
  )
)
}\if{html}{\out{</div>}}

\figure{navset-pill-list.png}{Screenshot of a navset_pill_list() example.}
}

\subsection{\code{page_navbar()}}{

Finally, \code{page_navbar()} provides full-page navigation container
similar to \code{navset_underline()} but where each \code{nav_panel()} is treated as a full page of content
and the navigation controls appear in a top-level navigation bar.
Note that the navbar background and underline styling can be controlled via \code{navbar_options}.

\code{page_navbar()} is complimented by \code{navset_bar()} which produces a similar layout intended to be used within an app.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{page_navbar(
  title = "My App",
  navbar_options = navbar_options(
    bg = "#0062cc",
    underline = TRUE
  ),
  nav_panel(title = "One", p("First tab content.")),
  nav_panel(title = "Two", p("Second tab content.")),
  nav_panel(title = "Three", p("Third tab content")),
  nav_spacer(),
  nav_menu(
    title = "Links",
    align = "right",
    nav_item(link_shiny),
    nav_item(link_posit)
  )
)
#> shiny devmode - Turning off caching of Sass -> CSS compilation. To turn caching on, call `options(sass.cache = TRUE)`
#> This message is displayed once every 8 hours.
}\if{html}{\out{</div>}}

\figure{page-navbar.png}{Screenshot of a page_navbar() example.}
}
}

\seealso{
\code{\link[=nav_panel]{nav_panel()}}, \code{\link[=nav_panel_hidden]{nav_panel_hidden()}} create panels of content.

\code{\link[=nav_menu]{nav_menu()}}, \code{\link[=nav_item]{nav_item()}}, \code{\link[=nav_spacer]{nav_spacer()}} create menus, items, or
space in the navset control area.

\code{\link[=nav_insert]{nav_insert()}}, \code{\link[=nav_remove]{nav_remove()}} programmatically add or remove nav
panels.

\code{\link[=nav_select]{nav_select()}}, \code{\link[=nav_show]{nav_show()}}, \code{\link[=nav_hide]{nav_hide()}} change the state of a
\code{\link[=nav_panel]{nav_panel()}} in a navset.

Other Panel container functions: 
\code{\link{nav-items}},
\code{\link{nav_select}()}
}
\concept{Panel container functions}
