% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adapt_pflanzenschutzmittelzulassung.R
\name{psm_mittel}
\alias{psm_mittel}
\title{List approved plant protection products}
\usage{
psm_mittel(kennr = NULL, params = list(), safe = TRUE, refresh = FALSE)
}
\arguments{
\item{kennr}{Optional product identification number (9 characters).}

\item{params}{Additional query parameters.}

\item{safe}{Logical; apply throttling and caching.}

\item{refresh}{Logical; refresh cached responses.}
}
\value{
A tibble with plant protection product data.
}
\description{
List approved plant protection products
}
\details{
The Pflanzenschutzmittelzulassung API provides access to Germany's plant
protection product database from the Bundesamt fuer Verbraucherschutz und
Lebensmittelsicherheit (BVL). This function returns approved pesticides.
Official docs: https://github.com/bundesAPI/pflanzenschutzmittelzulassung-api.
}
\examples{
\dontrun{
psm_mittel()
psm_mittel(kennr = "024780-00")
}

}
\seealso{
\code{\link[=psm_wirkstoffe]{psm_wirkstoffe()}} to list active ingredients,
\code{\link[=psm_stand]{psm_stand()}} for data version.
}
