% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coptic.R
\name{coptic_date}
\alias{coptic_date}
\alias{ethiopic_date}
\alias{as_coptic}
\alias{as_ethiopic}
\title{Coptic and Ethoiopic calendar dates}
\usage{
coptic_date(year = integer(), month = integer(), day = integer())

ethiopic_date(year = integer(), month = integer(), day = integer())

as_coptic(date)

as_ethiopic(date)
}
\arguments{
\item{year}{A numeric vector of years}

\item{month}{A numeric vector of months}

\item{day}{A numeric vector of days}

\item{date}{A numeric vector of dates}
}
\value{
A coptic or ethiopic vector object
}
\description{
These two calendars are identical apart from the starting point or epoch.
The Coptic calendar (also called the Alexandrian calendar) starts on
29 August 284 CE in the Julian calendar, while the Ethiopic (or Ethiopian)
calendar starts on 29 August 8 CE in the Julian calendar.
The Coptic calendar is used by the Coptic Orthodox and Coptic Catholic Churches,
while the Ethiopic calendar is the official state calendar of Ethiopia, and
unofficial calendar of Eritrea, and is
used by the Ethiopian and Eritrean Orthodox Churches. Both calendars have 13
months, with 12 months of 30 days and a 13th month of 5 or 6 days depending
on whether it is a leap year. Leap years occur every 4 years.
}
\examples{
tibble::tibble(
  gregorian = gregorian_date(2025, 1, 1:31),
  coptic = as_coptic(gregorian),
  ethiopic = as_ethiopic(gregorian)
)
coptic_date(1741, 5, 16:18)
as_date(Sys.Date(), calendar = cal_ethiopic)
as_coptic("2016-01-01")
as_ethiopic(Sys.Date())
}
\seealso{
\link{cal_coptic}, \link{cal_ethiopic}, \link{coptic_christmas}
}
