% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-docs.R
\name{cosine_similarity}
\alias{cosine_similarity}
\title{Cosine similarity between numeric vectors}
\usage{
cosine_similarity(a, b, eps = 1e-12)
}
\arguments{
\item{a, b}{Numeric vectors of equal length.}

\item{eps}{Non-negative numeric tolerance used to guard against division by
zero. Defaults to \code{1e-12}.}
}
\value{
A scalar double value in \verb{[-1, 1]} representing the cosine
similarity between \code{a} and \code{b}.
}
\description{
Computes the cosine of the angle between two numeric vectors. Both vectors
must have equal length and non-zero Euclidean norms.
}
\examples{
cosine_similarity(c(1, 2, 3), c(1, 2, 3))
cosine_similarity(c(1, 0), c(0, 1))
cosine_similarity(c(1, 2), c(-1, -2))
}
